%define oname terminado

%def_without check

Name: python3-module-%oname
Version: 0.9.1
Release: alt1

Summary: Terminals served by tornado websockets

License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/terminado/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

BuildRequires(pre): rpm-macros-sphinx
BuildPreReq: python-module-sphinx

%if_with check
BuildRequires: /dev/pts
BuildRequires: python3-module-nose
BuildRequires: python3-module-ptyprocess
BuildRequires: python3-module-tornado_xstatic
%endif

%py3_requires xstatic.pkg.termjs ptyprocess tornado_xstatic

%description
This is a Tornado websocket backend for the term.js Javascript terminal
emulator library.

Modules:

* terminado.management: controls launching virtual terminals, connecting
  them to Tornado's event loop, and closing them down.
* terminado.websocket: Provides a websocket handler for communicating
  with a terminal.
* terminado.uimodule: Provides a Terminal Tornado UI Module.

JS:

* terminado/_static/terminado.js: A lightweight wrapper to set up a
  term.js terminal with a websocket.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This is a Tornado websocket backend for the term.js Javascript terminal
emulator library.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
This is a Tornado websocket backend for the term.js Javascript terminal
emulator library.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
This is a Tornado websocket backend for the term.js Javascript terminal
emulator library.

This package contains documentation for %oname.

%prep
%setup

#%prepare_sphinx .
#ln -s ../objects.inv doc/

%build
%python3_build_debug

%install
%python3_install

#export PYTHONPATH=$PWD
#make -C doc pickle
#make -C doc html

#cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
rm -fR build
nosetests3 -v

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests

#%files docs
#%doc doc/_build/html/*

%changelog
