%define _unpackaged_files_terminate_build 1
%define  pypi_name testfixtures
%def_with check

Name: python3-module-%pypi_name
Version: 7.0.4
Release: alt1

Summary: A collection of helpers and mock objects for unit tests and doc tests
License: MIT
Group:   Development/Python3
URL: https://pypi.org/project/testfixtures
VCS: https://github.com/Simplistix/testfixtures

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(sybil)
BuildRequires: python3(django)
BuildRequires: python3(django.db.backends.sqlite3)
BuildRequires: python3(zope.component)
BuildRequires: python3(twisted.trial)

BuildRequires: python3(pytest)
BuildRequires: python3(pytest_django)
%endif

Source: %name-%version.tar

%description
TestFixtures is a collection of helpers and mock objects that are useful
when writing unit tests or doc tests.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

# don't ship tests
rm -r %buildroot%python3_sitelibdir/testfixtures/tests/

%check
# tox_create_default_config don't work due to flat layout
cat > tox.ini <<'EOF'
[testenv]
commands =
    python -m pytest -vra {posargs:testfixtures/tests}
EOF
%tox_check_pyproject

%files
%doc README.rst
%python3_sitelibdir/testfixtures/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
