%define _unpackaged_files_terminate_build 1

%define oname testtools

Name: python3-module-%oname
Version: 2.4.0
Release: alt1

Summary: Extensions to the Python standard library's unit testing framework

Group: Development/Python3
License: MIT
Url: http://pypi.python.org/pypi/testtools

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

Patch1: %oname-1.8.0-fedora-py3.patch

# https://github.com/testing-cabal/testtools/pull/271
Patch2: %oname-2.3.0-py37.patch
Patch3: testtools-2.4.0-fix_py39_test.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-extras python3-module-mimeparse
BuildRequires: python3-module-pbr python3-module-pytest python3-module-unittest2
BuildRequires: python3(testscenarios) python3(fixtures) python3-module-twisted-core-test

%add_python3_req_skip twisted
%add_findreq_skiplist %python3_sitelibdir/%oname/_compat2x.py
%py3_requires traceback2 mimeparse

%description
testtools is a set of extensions to the Python standard library's unit
testing framework. These extensions have been derived from years of
experience with unit testing in Python and come from many different
sources.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
testtools is a set of extensions to the Python standard library's unit
testing framework. These extensions have been derived from years of
experience with unit testing in Python and come from many different
sources.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1
%patch3 -p1

%prepare_sphinx3 .
ln -s ../objects.inv doc/

%build
export PBR_VERSION=%version
%python3_build

export PYTHONPATH=$PWD
%make -C doc html SPHINXBUILD=sphinx-build-3

%install
export PBR_VERSION=%version
%python3_install

%check
export PBR_VERSION=%version
%make check PYTHON=python3

%files
%doc LICENSE NEWS README*
%python3_sitelibdir/*

%files docs
%doc doc/_build/html/*


%changelog
