%define oname TTFQuery
%define sname ttfquery

Name: python3-module-%sname
Version: 1.0.5
Release: alt4

Summary: FontTools-based package for querying system fonts

Group: Development/Python3
License: BSD
Url: http://ttfquery.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-git: https://github.com/mindw/ttfquery
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools python3-module-fonttools
BuildPreReq: python-tools-2to3

Conflicts: python-module-%sname < %EVR
Obsoletes: python-module-%sname < %EVR

%description
TTFQuery builds on the FontTools package to allow the Python programmer
to accomplish a number of tasks:

  * query the system to find installed fonts
  * retrieve metadata about any TTF font file (even those not yet
    installed)
      o abstract family type
      o proper font name
      o glyph outlines
  * build simple metadata registries for run-time font matching

With these functionalities, it is possible to readily
create OpenGL solid-text rendering libraries which
can accept abstract font-family names as font specifiers
and deliver platform-specific TTF files to match those libraries.

TTFQuery doesn't provide rendering services, but a sample
implementation can be found in the OpenGLContext project, from
which TTFQuery was refactored.

%prep
%setup

find . -type f -name '*.py' -exec 2to3 -w -n '{}' +

%build
%python3_build

%install
%python3_install

%files
%doc license.txt doc/index.html
%_bindir/*
%python3_sitelibdir/%sname/
%python3_sitelibdir/*egg-info/

%changelog
