%define _unpackaged_files_terminate_build 1
%define pypi_name virtualenv
%define system_wheels_path %(%__python3 -c 'import os, sys, system_seed_wheels; sys.stdout.write(os.path.dirname(system_seed_wheels.__file__))' 2>/dev/null || echo unknown)

%def_with check

Name: python3-module-%pypi_name
Version: 20.30.0
Release: alt0.p10.1
Summary: Virtual Python Environment builder
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/virtualenv/
VCS: https://github.com/pypa/virtualenv
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
# system seed wheels
Requires: python3-module-system-seed-wheels-wheels
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_metadata_extra test
BuildRequires: python3-module-system-seed-wheels-wheels
%endif

%description
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python

%description -l ru_RU.UTF-8
Утилита для создания изолированных окружений для Python.

С Virtualenv вы можете создать независимые наборы библиотек для каждого
вашего проекта. Опционально вы можете запретить использование системных
библиотек.

Просто выполните "virtualenv /your/dir" и полное виртуальное окружение Python
будет создано в каталоге, который вы указали (setuptools  и easy_install будут
также установлены и при вызове будут устанавливать новые библиотеки в ваше
виртуальное окружение). Чтобы выполнить ваши скрипты в вновь созданном окружение
запускайте их при помощи /your/dir/bin/python

%prep
%setup
%patch -p1

# remove all bundled seed wheels
rm src/virtualenv/seed/wheels/embed/*.whl
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install
mv %buildroot%_bindir/{virtualenv,virtualenv3}

%check
export PIP_FIND_LINKS=%system_wheels_path
%pyproject_run_pytest -ra tests

%files
%doc README.md
%_bindir/virtualenv3
%python3_sitelibdir/virtualenv/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
