%define _unpackaged_files_terminate_build 1
%define oname webtest

%def_with check

Name: python3-module-%oname
Version: 2.0.35
Release: alt1
Summary: Helper to test WSGI applications
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/WebTest/

# git://github.com/Pylons/webtest.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(bs4)
BuildRequires: python3(mock)
BuildRequires: python3(PasteDeploy)
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(waitress)
BuildRequires: python3(webob)
BuildRequires: python3(wsgiproxy)
%endif

%description
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.

%prep
%setup
%autopatch -p1

%build
%python3_build

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --console-scripts --no-deps -vvr

%files
%python3_sitelibdir/webtest/
%python3_sitelibdir/WebTest-%version-py%_python3_version.egg-info/

%changelog
