%define oname xlib

# There is no display in hasher
%def_without check

Name: python3-module-%oname
Version: 0.31
Release: alt1

Summary: Python X Library

Group: Development/Python3
License: LGPLv2.1
Url: https://github.com/python-xlib/python-xlib

Source: %name-%version.tar

BuildRequires: /usr/bin/texi2html
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools_scm

%if_with check
BuildRequires: python3-module-six
BuildRequires: python3(mock)
BuildRequires: python3-module-pytest
%endif

%description
The Python X Library is a complete X11R6 client-side implementation,
written in pure Python. It can be used to write low-levelish X Windows
client applications in Python.

%package docs
Summary: Documentation and examples for Python X Library
Group: Development/Documentation
BuildArch: noarch

%description docs
The Python X Library is a complete X11R6 client-side implementation,
written in pure Python. It can be used to write low-levelish X Windows
client applications in Python.

This package contains documentation and examples for Python X Library.

%prep
%setup

%build
%python3_build

pushd doc/html
%make SRCS=$PWD/../src TOPSRC=$PWD/../src/python-xlib.texi
popd

%install
%python3_install

# hack for x86_64 build
test -d %buildroot%_libdir || mv %buildroot%prefix/lib %buildroot%_libdir || :

%check
python3 setup.py test
py.test3 -vv

%files
%doc README.rst LICENSE TODO
%python3_sitelibdir/*

%files docs
%doc examples doc/html/*.html

%changelog
