%define _unpackaged_files_terminate_build 1
%define pypi_name PyYAML
%define mod_name yaml

%def_with check

Name: python3-module-%mod_name
Version: 6.0.1
Release: alt1.1

Summary: PyYAML, a YAML parser and emitter for Python
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/PyYAML/
Vcs: https://github.com/yaml/pyyaml

Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: fix-build-with-cython3.patch

# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

BuildRequires: libyaml-devel

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata
%endif

%description
YAML is a data serialization format designed for human readability
and interaction with scripting languages.

PyYAML is a YAML parser and emitter for the Python programming
language.  PyYAML features a complete YAML 1.1 parser, Unicode
support, and relatively sensible error messages.

%prep
%setup
%patch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- python3 tests/lib/test_all.py

%files
%doc CHANGES README*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/_yaml/
%python3_sitelibdir/%pypi_name-%version.dist-info/

%changelog
