%define _unpackaged_files_terminate_build 1
%define mname yieldfrom
%define oname %mname.urllib3

Name: python3-module-%oname
Version: 0.1.4
Release: alt3
Summary: Asyncio HTTP library with thread-safe connection pooling, file post, and more
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/yieldfrom.urllib3/

# https://github.com/rdbhost/yieldfromUrllib3.git
Source: %oname-%version.zip

BuildRequires: unzip
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(asyncio) python3-module-nose
BuildRequires: python3-module-yieldfrom.http.client
BuildRequires: python3-module-tornado
BuildRequires: python3-module-pycares python3-module-zope

Requires: python3-module-%mname = %EVR

%description
Yieldfrom is a project to port various useful Python 3 libraries, both
standard library and otherwise, to work under Asyncio. The intention is
to have the port be as alike as possible to the original, so that the
learning curve is minimal, and to make porting dependent modules as easy
as possible.

This package is a port of the Urllib3 package.

%package -n python3-module-%mname
Summary: Core files of %mname
Group: Development/Python3

%description -n python3-module-%mname
Core files of %mname.

%prep
%setup -q -n %{oname}-%{version}

%build
%python3_build_debug

%install
%python3_install

%if "%_libdir" != "%_libexecdir"
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

install -d %buildroot%pytho3_sitelibdir/%mname
install -p -m644 %mname/__init__.py \
	%buildroot%python3_sitelibdir/%mname/

%check
python3 setup.py test

%files
%doc *.txt *.rst
%python3_sitelibdir/%mname/*
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/%mname/__init__.*
%exclude %python3_sitelibdir/%mname/__pycache__/__init__.*

%files -n python3-module-%mname
%dir %python3_sitelibdir/%mname
%dir %python3_sitelibdir/%mname/__pycache__
%python3_sitelibdir/%mname/__init__.*
%python3_sitelibdir/%mname/__pycache__/__init__.*
%python3_sitelibdir/*.pth

%changelog
