%define _unpackaged_files_terminate_build 1
%define oname zope.annotation

%def_with check

Name: python3-module-%oname
Version: 4.7.0
Release: alt2

Summary: Object annotation mechanism
License: ZPLv2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.annotation
#Git: https://github.com/zopefoundation/zope.annotation.git

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.location
BuildRequires: python3-module-zope.proxy

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
%endif

%description
This package provides a mechanism to store additional information about
objects without need to modify object class.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing zope.testrunner

%description tests
This package contains tests for %oname

%prep
%setup
%patch0 -p1

%build
%python3_build

%install
%python3_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
# cancel coverage execution during unit testing
sed -i 's|btrees,||g' tox.ini
sed -i 's|-m zope.testrunner |-m zope-testrunner3 |g' tox.ini
sed -i 's|coverage run [ -a]\{0,\}-m||g' tox.ini
sed -i 's|[[:space:]]coverage|#coverage|g' tox.ini
# cancel docbuild tests
sed -i 's|sphinx|#py3_sphinx|g' tox.ini
sed -i '/\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp {env:_PYTEST_BIN:} \{envbindir\}\/zope-testrunner3\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/zope-testrunner3' tox.ini
sed -i '/setenv =$/a \
    py%{python_version_nodots python3}: _PYTEST_BIN=%_bindir\/zope-testrunner3' tox.ini

tox.py3 --sitepackages -e py%{python_version_nodots python3} -v

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests

%changelog
