%define oname zope.hookable
%define descr \
Support the efficient creation of hookable objects, which are callable \
objects that are meant to be replaced by other callables, at least \
optionally. \
\
The idea is you create a function that does some default thing and make \
it hookable. Later, someone can modify what it does by calling its \
sethook method and changing its implementation.  All users of the \
function, including those that imported it, will see the change.

Name: python3-module-%oname
Version: 5.0.1
Release: alt2

Summary: Hookable object support
Group: Development/Python3

License: ZPL-2.1
Url: http://pypi.python.org/pypi/zope.hookable/
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-macros-sphinx3
BuildRequires: python3-module-sphinx

%py3_requires zope

%description
%descr

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
%descr

This package contains documentation for %oname.

%package pickles
Summary: Pickles for zope.hookable
Group: Development/Python

%description pickles
%descr

This package contains pickles for zope.hookable.

%package tests
Summary: Tests for zope.hookable
Group: Development/Python
Requires: %name = %version-%release
%py3_requires zope.testing

%description tests
%descr

This package contains tests for zope.hookable.

%prep
%setup

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%python3_build

export PYTHONPATH=$PWD/src
%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

%install
%python3_install

install -d %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/pickle

%files tests
%python3_sitelibdir/*/*/tests

%files docs
%doc docs/_build/html/*

%files pickles
%python3_sitelibdir/*/pickle

%changelog
