%define _unpackaged_files_terminate_build 1
%define oname zope.proxy

%def_without check

Name: python3-module-%oname
Version: 4.3.5
Release: alt2
Summary: Generic Transparent Proxies
License: ZPL
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.proxy/
#Git: https://github.com/zopefoundation/zope.proxy.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-repoze.sphinx.autointerface
BuildRequires: python3-module-zope.security
%endif

%py3_requires zope zope.interface

%description
Proxies are special objects which serve as mostly-transparent wrappers
around another object, intervening in the apparent behavior of the
wrapped object only when necessary to apply the policy (e.g., access
checking, location brokering, etc.) for which the proxy is responsible.

%package tests
Summary: Tests for Generic Transparent Proxies
Group: Development/Python3
Requires: %name = %EVR

%description tests
Proxies are special objects which serve as mostly-transparent wrappers
around another object, intervening in the apparent behavior of the
wrapped object only when necessary to apply the policy (e.g., access
checking, location brokering, etc.) for which the proxy is responsible.

This package contains tests for Generic Transparent Proxies.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%python3_build

%install
%python3_install

%check
sed -i 's|zope-testrunner |zope-testrunner3 |g' tox.ini
sed -i 's|sphinx-build|py3_sphinx-build|g' tox.ini

sed -i '/\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
setenv =\
    py%{python_version_nodots python3}: _PYTEST_BIN=%_bindir\/zope-testrunner3\
    py%{python_version_nodots python3}: _DOCTEST_BIN=%_bindir\/py3_sphinx-build\
commands_pre =\
    \/bin\/cp {env:_PYTEST_BIN:} \{envbindir\}\/zope-testrunner3\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/zope-testrunner3\
    \/bin\/cp {env:_DOCTEST_BIN:} \{envbindir\}\/py3_sphinx-build\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/py3_sphinx-build' tox.ini

tox.py3 --sitepackages -e py%{python_version_nodots python3} -v

%files
%doc *.txt *.rst docs/*.rst
%_includedir/python3*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests

%changelog
