%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%set_verify_elf_method strict

%define shortname qalculate

Name: qalculate-gtk
Version: 4.1.1
Release: alt2
Summary: A very versatile desktop calculator - GTK+ version.
Group: Office
License: GPL-2.0+
Url: https://qalculate.github.io/

# libqalculate support invoking /usr/bin/gnuplot
Requires: /usr/bin/gnuplot

# https://github.com/Qalculate/qalculate-gtk.git
Source: %name-%version.tar
# bug#42143
Patch1: dontshowuaflag.patch
Patch2: letsreturnourflags.patch

BuildRequires: gcc-c++ libcln-devel libdbus-glib libglade-devel libgmp-devel libgnome-devel
BuildRequires: libqalculate-devel >= %version
BuildRequires: perl-XML-Parser scrollkeeper yelp intltool
BuildRequires: desktop-file-utils
BuildRequires: pkgconfig(libxml-2.0) pkgconfig(gtk+-3.0)

%description
A GTK+ graphical interface for Qalculate!

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure --disable-rpath --enable-static=no
%make_build

%install
%makeinstall_std

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Calculator \
	--add-category=GTK \
	%buildroot%_desktopdir/qalculate-gtk.desktop

%find_lang %name

%files -f %name.lang
%doc COPYING
%doc AUTHORS ChangeLog README README.md
%_bindir/%name
%_libexecdir/qalculate-search-provider
%_man1dir/*.1*
%_datadir/metainfo/%name.appdata.xml
%_defaultdocdir/%name
%_desktopdir/*
%_iconsdir/hicolor/*x*/apps/%{shortname}.png
%_iconsdir/hicolor/scalable/apps/%{shortname}.svg
%_datadir/dbus-1/services/io.github.Qalculate.SearchProvider.service
%_datadir/gnome-shell/search-providers/io.github.Qalculate.search-provider.ini

%changelog
