Name: qfsm
Version: 0.56
Release: alt1

Summary: Graphical tool for designing finite state machine
License: GPLv3
Group: Education

Url: https://github.com/AaronErhardt/qfsm
Source: %version.tar.gz
Patch: qfsm-0.56-examples.patch

# Automatically added by buildreq on Mon Jul 12 2021
# optimized out: cmake-modules fontconfig glibc-kernheaders-generic glibc-kernheaders-x86 libqt4-core libqt4-gui libqt4-network libqt4-opengl libqt4-qt3support libqt4-script libqt4-sql libqt4-sql-sqlite libqt4-svg libqt4-xml libsasl2-3 libssl-devel libstdc++-devel pkg-config python3 python3-base sh4
BuildRequires: cmake gcc-c++ libgraphviz-devel libqt4-devel

%description
Qfsm is a graphical tool for designing finite state machine.
It is written in C++ using the Qt library.
Features include:

- Drawing, Editing and Printing of states diagrams
- Binary, ASCII or "free text" condition codes
- Multiple windows
- Integrity check
- Interactive simulation
- HDL export in the file formats: AHDL, VHDL, Verilog HDL, KISS
- Diagram export in the formats: EPS and SVG
- State table export in Latex, HTML or plain text format
- Ragel file export (used for C/C++, Java or Ruby code generation)

%prep
%setup
%patch -p1

%build
%cmake
%cmake_build
cd po
lupdate-qt4 ../src/ -ts *ts
lrelease-qt4 *ts

%install
%cmake_install
rm -rf %buildroot%_defaultdocdir/%name
ln -s %name-%version/user %buildroot%_defaultdocdir/%name
%find_lang %name

%files -f %name.lang
%doc *.md
%doc doc/user examples
%_bindir/%name
%_defaultdocdir/%name
%dir %_datadir/%name
%_datadir/%name/*
%_desktopdir/*.desktop
%_datadir/mimelnk/application/*.desktop
%_iconsdir/hicolor/*/*/*

%changelog
