%def_disable qt4
%def_enable qt5
%define git_rev 7d856c17

Name:    qtcurve
Version: 1.9.0
Release: alt1.git%git_rev.1
Epoch:   2

Summary: A set of widget styles for GTK+ and Qt widget toolkits
License: LGPL-2.1+
Group:   Graphical desktop/Other
Url:     https://github.com/KDE/qtcurve

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Patch1: qtcurve-1.8.18-no_env.patch
Patch2: maint.patch
Patch3: qtcurve-1.9.0-build_testing.patch
Patch4: qtcurve-1.9.0-gcc9.patch
Patch5: qtcurve-1.9.0-libreoffice-crashfix.patch
Patch6: qtcurve-1.9.0-no-X-buildfix.patch
Patch7: qtcurve-1.9.0-qt-5.15.patch

BuildRequires(pre): kde-common-devel rpm-macros-qt3 rpm-macros-qt4 cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++ libgtk+2-devel
%if_enabled qt4
BuildRequires: kde4libs-devel
BuildRequires: kde4base-workspace-devel
%endif
BuildRequires: git-core
BuildRequires: pkgconfig(x11-xcb)
%if_enabled qt5
BuildRequires(pre): rpm-build-kf5
BuildRequires: pkgconfig(Qt5Gui) pkgconfig(Qt5Widgets) pkgconfig(Qt5Svg) pkgconfig(Qt5DBus)
BuildRequires: pkgconfig(Qt5Quick)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: extra-cmake-modules
BuildRequires: kf5-kio-devel
BuildRequires: kf5-kdelibs4support-devel
BuildRequires: kf5-kemoticons-devel
BuildRequires: kf5-kitemmodels-devel
BuildRequires: kf5-kinit-devel
BuildRequires: kf5-kconfigwidgets-devel
BuildRequires: kf5-sonnet-devel
BuildRequires: kf5-ki18n-devel
BuildRequires: kf5-kdoctools-devel-static
BuildRequires: kf5-frameworkintegration-devel
%endif

Requires: %name-gtk2 = %version-%release
%if_enabled qt4
Requires: %name-qt4 = %version-%release
%endif
%if_enabled qt5
Requires: %name-qt5 = %version-%release
Requires: %name-kf5 = %version-%release
%endif

%description
QtCurve is a desktop theme for the GTK+ and Qt widget toolkits, allowing
users to achieve a uniform look between these widget toolkits.

%package libs
Summary: Runtime libraries for QtCurve
Group:   Graphical desktop/Other

%description libs
Runtime libraries for QtCurve

%package -n gtk2-themes-%name
Summary: The QtCurve engine for GTK2
Group:   Graphical desktop/GNOME
Provides: gtk-engines-%name
Provides: %name-gtk2 = %version-%release
Obsoletes: gtk-engines-%name < %version-%release gtk1-themes-%name < %version-%release

%description -n gtk2-themes-%name
The QtCurve engine for GTK2

%if_enabled qt4
%package -n qt4-styles-%name
Group:   Graphical desktop/KDE
Summary: QtCurve style for Qt4
Provides: kde4-styles-%name = %version-%release
Obsoletes: kde4-styles-%name < %version-%release
Provides: %name-qt4 = %version-%release

%description -n qt4-styles-%name
This is a set of widget styles for Qt4
%endif

%if_enabled qt5
%package -n qt5-styles-%name
Group:   Graphical desktop/KDE
Summary: QtCurve style for Qt5
Provides: %name-qt5 = %version-%release

%description -n qt5-styles-%name
This is a set of widget styles for Qt5

%package -n kf5-styles-%name
Group:   Graphical desktop/KDE
Summary: QtCurve style for KF5
Provides: %name-kf5 = %version-%release

%description -n kf5-styles-%name
This is a set of widget styles for KF5
%endif

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%build
%cmake  -GNinja \
	-DENABLE_QT5:BOOL=%{?_enable_qt5:ON}%{!?_enable_qt5:OFF} \
	-DQTC_QT4_ENABLE_KDE:BOOL=OFF
%cmake_build

%install
%cmake_install

# unpackaged files
rm -fv %buildroot%_libdir/libqtcurve-{cairo,utils}.so
rm -f %buildroot%_datadir/kxmlgui5/QtCurve/QtCurveui.rc

# Move KF5 file to appropriate place
mkdir -p %buildroot%_K5data/kstyle/themes/
mv %buildroot%_datadir/kstyle/themes/qtcurve.themerc %buildroot%_K5data/kstyle/themes/

%files

%files libs
%doc AUTHORS Bugs.md README.md TODO.md ChangeLog.md COPYING
%_libdir/libqtcurve-utils.so.2*

%files -n gtk2-themes-%name
%_libdir/gtk-2.0/*/engines/libqtcurve.so
%_libdir/libqtcurve-cairo.so.1*
%_datadir/themes/QtCurve/

%if_enabled qt4
%files -n qt4-styles-%name
%_qt4dir/plugins/styles/qtcurve.so
%endif

%if_enabled qt5
%files -n qt5-styles-%name
%_qt5_plugindir/styles/qtcurve.so

%files -n kf5-styles-%name
%_qt5_plugindir/kstyle_qtcurve5_config.so
%_K5data/kstyle/themes/qtcurve.themerc
%endif

%changelog
