# Check also https://github.com/EasyCoding/range-v3/blob/master/range-v3.spec

%def_with test

Name: range-v3
Version: 0.11.0
Release: alt2

Summary: Range library for C++14/17/20, basis for C++20's std::ranges

License: Boost
Group: Development/C++
Url: https://github.com/ericniebler/range-v3

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/ericniebler/range-v3/archive/%version.tar.gz
Source: %name-%version.tar

# https://bugzilla.altlinux.org/show_bug.cgi?id=37930
# https://bugzilla.altlinux.org/show_bug.cgi?id=38830
Patch: a91f0e1be27a31c446452a753001d4518ef83a6b.patch

BuildArch: noarch

BuildRequires: gcc-c++

BuildRequires(pre): rpm-build-intro >= 2.1.14
BuildRequires: cmake

%if_with test
BuildRequires: ctest
%endif

%description
Range library for C++14/17/20. This code was the basis
of a formal proposal to add range support to the C++ standard library.
That proposal evolved through a Technical Specification,
and finally into P0896R4 "The One Ranges Proposal"
which was merged into the C++20 working drafts in November 2018.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C++
Provides: %name-static = %version-%release

%description -n lib%name-devel
Range library for C++14/17/20. This code was the basis
of a formal proposal to add range support to the C++ standard library.
That proposal evolved through a Technical Specification,
and finally into P0896R4 "The One Ranges Proposal"
which was merged into the C++20 working drafts in November 2018.

%prep
%setup
%patch -p1
%__subst 's|DESTINATION lib/cmake/range-v3|DESTINATION share/cmake/range-v3|g' CMakeLists.txt
%__subst '/-Werror/d' cmake/ranges_flags.cmake

%build
# needed for test
%cmake_insource \
%if_without test
    -DRANGE_V3_TESTS:BOOL=OFF \
%endif
    -DRANGE_V3_DOCS:BOOL=OFF
%make_build

%check
%if_with test
ctest --output-on-failure
%endif

%install
%makeinstall_std
rm -vf %buildroot%_includedir/module.modulemap

%files -n lib%name-devel
%doc README.md CREDITS.md TODO.md
%doc LICENSE.txt
%_includedir/meta/
%_includedir/range/
%_includedir/concepts
%_includedir/std
%_datadir/cmake/%name

%changelog
