%def_disable snapshot

%define rev %nil
%if_enabled snapshot
%define git_distance 1175
%endif

%define xdg_name com.rawtherapee.RawTherapee

Name: rawtherapee
Version: 5.8%{?_enable_snapshot:.%git_distance}
Release: alt1.1

Summary: THe Experimental RAw Photo Editor
License: GPLv3+
Group: Graphics
URL: https://www.rawtherapee.com

%if_enabled snapshot
Vcs: https://github.com/Beep6581/RawTherapee
Source: rawtherapee-%version.tar
%else
# use full archive not git-archive to avoid dancing around version
#Source: %url/shared/source/%name-%version.tar.xz
Source: https://github.com/Beep6581/RawTherapee/releases/download/%version/%name-%version.tar.xz
%endif

%define gtk_ver 3.24.7
%define tiff_ver 4.0.4
%define rsvg_ver 2.40

Requires: %name-data = %version-%release
Requires: libgtk+3 >= %gtk_ver

BuildRequires(pre): cmake >= 2.8.8
%{?_enable_snapshot:BuildRequires: git}
BuildRequires: libgtk+3-devel >= %gtk_ver librsvg-devel >= %rsvg_ver
BuildRequires: libtiff-devel >= %tiff_ver
BuildRequires: bzlib-devel gcc-c++ libgomp-devel libgtkmm3-devel libiptcdata-devel
BuildRequires: libjpeg-devel liblcms2-devel libpng-devel libfftw3-devel
BuildRequires: libexpat-devel libpixman-devel libcanberra-gtk3-devel
BuildRequires: libXdmcp-devel libXdamage-devel libXxf86vm-devel
BuildRequires: libexiv2-devel libharfbuzz-devel
BuildRequires: liblensfun-devel

%description
Raw Therapee is a free RAW converter and digital photo processing software.

%package data
Summary: Arch independent files for Raw Therapee
Group: Graphics
BuildArch: noarch

%description data
This package provides noarch data needed for Raw Therapee to work.

%prep
%setup
# Do not install useless rtstart:
subst "s|install (PROGRAMS rtstart|\#install (PROGRAMS rtstart|" CMakeLists.txt

%build
%define optflags -O3 -g
%add_optflags %(getconf LFS_CFLAGS)
%cmake -DCMAKE_BUILD_TYPE:STRING="Release" \
	%{?_disable_snapshot:-DCACHE_NAME_SUFFIX=""} \
	%{?_enable_snapshot:-DCACHE_NAME_SUFFIX="5-dev"}
%cmake_build

%install
%cmake_install

rm -f %buildroot/%_datadir/doc/rawtherapee/*.txt

%files
%_bindir/%name
%_bindir/%name-cli
%doc AUTHORS.txt LICENSE.txt RELEASE_NOTES.txt

%files data
%_desktopdir/%name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/apps/*
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
