Name: rdiff-backup
Version: 2.0.5
Release: alt1

Summary: Backup software

License: GPL
Group: File tools
Url: http://www.nongnu.org/rdiff-backup/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/rdiff-backup/rdiff-backup/archive/v%version.tar.gz
Source: %name-%version.tar

# from http://wiki.rdiff-backup.org/wiki/index.php/BashCompletion
Source1: rdiff-backup.bash_completion

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools_scm
BuildRequires: librsync-devel >= 0.9.6

%description
rdiff-backup is a script, written in Python, that backs up one
directory to another and is intended to be run periodically (nightly
from cron for instance). The target directory ends up a copy of the
source directory, but extra reverse diffs are stored in the target
directory, so you can still recover files lost some time ago. The idea
is to combine the best features of a mirror and an incremental backup.
rdiff-backup can also operate in a bandwidth efficient manner over a
pipe, like rsync. Thus you can use rdiff-backup and SSH to securely
back a hard drive up to a remote location, and only the differences
from the previous backup will be transmitted.

%prep
%setup
#patch1 -p1
#patch2 -p1
#patch3 -p1

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install
rm -rfv %_docdir/%name/Windows-*.md

%files
%_docdir/%name/
%_bindir/rdiff-backup
%_bindir/rdiff-backup-statistics
%_bindir/rdiff-backup-delete
%_man1dir/rdiff-backup.1*
%_man1dir/rdiff-backup-statistics.1*
%python3_sitelibdir/rdiff_backup/
%python3_sitelibdir/*.egg-info
%_datadir/bash-completion/completions/%name

%changelog
