%define oname roundcubemail
%define rel %nil
Name: roundcube
Version: 1.4.11
Release: alt2

Summary: Browser-based multilingual IMAP client with an application-like user interface

License: GPL2
Group: Networking/Mail
Url: http://roundcube.net/

# Source-url: https://github.com/roundcube/roundcubemail/releases/download/%version%rel/roundcubemail-%version%rel-complete.tar.gz
Source: %name-%version.tar
Source1: %name.apache.conf
Source2: composer.json-dist
Patch0: roundcube-1.2.4-sso-alt.patch
BuildArch: noarch

BuildPreReq: rpm-build-apache2
BuildRequires: rpm-macros-webserver-common
BuildRequires: php7

Requires: composer >= 1.1.3

# check it with composer.json or on http://trac.roundcube.net/wiki/Howto_Requirements
Requires: php7 >= 7.1
# php-engine
Requires: webserver-common
Requires: pear-Mail_Mime >= 1.10.0
Requires: pear-Net_SMTP >= 1.7.1
Requires: pear-Net_IDNA2 >= 0.1.1
Requires: pear-Auth_SASL >= 1.0.6
# managesieve plugin
Requires: pear-Net_Sieve >= 1.3.4
# for enigma plugin
#Requires: pear-Crypt_GPG >= 1.4.1
Requires: pear-Net_Socket >= 1.0.12
Requires: pear-Mail_mimeDecode

Requires: php7-dom php7-mcrypt php7-openssl
Requires: php7-pdo_mysql
Requires: php7-mbstring php7-fileinfo php7-mcrypt php7-zip
# TODO: check if needed
Requires: php7-sockets php7-intl 
# missed. use browser's spelling
#php7-pspell
# for endroid/qrcode
Requires: php7-gd2

Provides: roundcube-plugin-acl
Obsoletes: roundcube-plugin-acl

AutoReq: yes,nomingw32,noshell

#add_python3_path %_datadir/%name/plugins
%add_findreq_skiplist %_datadir/%name/plugins/*
%add_python3_req_skip %_datadir/%name/plugins/*
%add_python3_compile_exclude %_datadir/%name/plugins/*

%description
RoundCube Webmail is a browser-based multilingual IMAP client with an application-like user interface.
It provides full functionality you expect from an e-mail client, including MIME support, LDAP address book,
folder manipulation, message searching and spell checking.
RoundCube Webmail is written in PHP and requires a MySQL or Postgres database.

%package apache2
Summary: %name's apache config file
Group: System/Servers
Requires: %name = %version-%release
Requires: apache2-httpd apache2-mod_php7
BuildArch: noarch

%description apache2
%name's apache config file

%prep
%setup
#patch0 -p2
#sed -i 's,php_,php5_,' .htaccess

# disable Reply button
%__subst 's|\(command="reply"\)|\1 style="display:none"|g' \
    skins/larry/includes/mailtoolbar.html skins/classic/includes/messagetoolbar.html \
    skins/elastic/templates/messagepart.html skins/elastic/templates/includes/mail-menu.html

# disable SymLinksIfOwnerMatch
%__subst 's|\(.*SymLinksIfOwnerMatch.*\)|#\1|g' .htaccess

#if [ ! -s program/js/jquery.min.js ] ; then
#    echo "run bin/install-jsdeps.sh after download new build"
#fi

%install
mkdir -p %buildroot%_datadir/%name/
install -Dpm 0644 index.php %buildroot%_datadir/%name/index.php
install -Dpm 0644 .htaccess %buildroot%_datadir/%name/.htaccess
#install -Dpm 0644 jsdeps.json %buildroot%_datadir/%name/jsdeps.json
#install -Dpm 0644 robots.txt %buildroot%_datadir/%name/robots.txt
cp -ar SQL bin program installer plugins skins public_html %buildroot%_datadir/%name/

cat > %buildroot%_datadir/%name/installer/.htaccess << EOF
# deny webserver access to this directory
<ifModule mod_authz_core.c>
    Require all denied
</ifModule>
<ifModule !mod_authz_core.c>
    Deny from all
</ifModule>
EOF

mkdir -p %buildroot%_localstatedir/%name/{temp,logs,enigma}/
ln -s %_localstatedir/%name/logs/ %buildroot%_datadir/%name/
ln -s %_localstatedir/%name/temp/ %buildroot%_datadir/%name/
rm -rf %buildroot%_datadir/%name/plugins/enigma/home/
ln -s %_localstatedir/%name/enigma/ %buildroot%_datadir/%name/plugins/enigma/home

cp %buildroot%_datadir/%name/installer/.htaccess %buildroot%_localstatedir/%name/temp/
cp %buildroot%_datadir/%name/installer/.htaccess %buildroot%_localstatedir/%name/logs/
cp %buildroot%_datadir/%name/installer/.htaccess %buildroot%_localstatedir/%name/enigma/

mkdir -p %buildroot%_sysconfdir/%name/
cp -ar config/* %buildroot%_sysconfdir/%name/
ln -s  %_sysconfdir/%name/ %buildroot%_datadir/%name/config

install -Dpm 0644 %SOURCE2 %buildroot%_sysconfdir/%name/composer.json
ln -s  %_sysconfdir/%name/composer.json %buildroot%_datadir/%name/composer.json

ln -s  %_docdir/%name-%version %buildroot%_datadir/%name/doc

install -pD -m0644 %SOURCE1 %buildroot%apache2_extra_available/%name.conf

rm -fv %buildroot%_datadir/roundcube/plugins/password/helpers/chpass-wrapper.py

%post apache2
service httpd2 condreload

%postun apache2
service httpd2 condreload

%files
%_datadir/%name/
%dir %attr(2775,root,%webserver_group) %_localstatedir/%name/
%dir %attr(2775,root,%webserver_group) %_localstatedir/%name/logs/
%dir %attr(2775,root,%webserver_group) %_localstatedir/%name/temp/
%dir %attr(2775,root,%webserver_group) %_localstatedir/%name/enigma/
%_localstatedir/%name/logs/.htaccess
%_localstatedir/%name/temp/.htaccess
%_localstatedir/%name/enigma/.htaccess
%dir %attr(0750,root,%webserver_group) %_sysconfdir/%name/
%config(noreplace) %attr(0640,root,%webserver_group) %_sysconfdir/%name/*
%doc CHANGELOG INSTALL LICENSE README.md UPGRADING SQL/

%files apache2
%config(noreplace) %apache2_extra_available/%name.conf

%changelog
