Group: System/Libraries
%define oldname fedora-gnat-project-common
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           rpm-build-gnat
Version:        3.15
Release:        alt1_1
Summary:        Files shared by Ada libraries
Summary(sv):    Gemensamma filer för adabibliotek

License:        Copyright only
URL:            https://src.fedoraproject.org/cgit/rpms/fedora-gnat-project-common.git
Source1:        directories.gpr.in
Source2:        macros.gnat.in
Source3:        gnat-project.sh
Source4:        gnat-project.csh
Source5:        configure
Source6:        LICENSE
BuildArch:      noarch

BuildRequires:  sed
Requires:       setup
Source44: import.info
Patch33: macros.gnat.in.patch
Provides: fedora-gnat-project-common = %version
Requires: rpm-macros-gnat = %{version}-%{release}
# macros.gnat requires build_*flags:
# macros.gnat uses _smp_build_ncpus (RPM 4.15),
# and an RPM that knows about /usr/lib/rpm/macros.d (4.11) is required:

%description
The fedora-gnat-project-common package contains files that are used by the GNAT
project files of multiple Ada libraries, and also GNAT-specific RPM macros.

%description -l sv
Paketet fedora-gnat-project-common innehåller filer som används av
GNAT-projektfilerna för flera adabibliotek, samt GNAT-specifika RPM-makron.

%global _GNAT_project_dir /usr/share/gpr
# _GNAT_project_dir is defined here and copied from here to macros.gnat so that
# this package won't build-require itself.



%package -n rpm-macros-gnat
Summary: Set of RPM macros for packaging GNAT applications
Group: Development/Other
BuildArch: noarch

%description -n rpm-macros-gnat
Set of RPM macros for packaging GNAT applications for ALT Linux.
Install this package if you want to create RPM packages that use GNAT.

%prep
%setup -n %{oldname}-%{version} -c -T
cp --preserve=timestamps %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} %{SOURCE5} %{SOURCE6} .
%patch33 -p0


%build
exec_prefix=%{_exec_prefix} bindir=%{_bindir} libexecdir=%{_libexecdir} includedir=%{_includedir} GNAT_project_dir=%{_GNAT_project_dir} ./configure


%install
mkdir --parents %{buildroot}%{_GNAT_project_dir} %{buildroot}%{_sysconfdir}/profile.d %{buildroot}%{_rpmmacrosdir}
cp -p directories.gpr %{buildroot}%{_GNAT_project_dir}/
cp -p gnat-project.sh gnat-project.csh %{buildroot}%{_sysconfdir}/profile.d/
cp -p macros.gnat %{buildroot}%{_rpmmacrosdir}/gnat


%files
%doc --no-dereference LICENSE
%{_GNAT_project_dir}
%config(noreplace) %{_sysconfdir}/profile.d/*

%files -n rpm-macros-gnat
%_rpmmacrosdir/*



%changelog
