# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
# Cannot be enabled due to librrpage.so:
#  %%define _stripped_files_terminate_build 1
#  %%set_verify_elf_method strict

Name:		rr
Version:	5.6.0
Release:	alt1
Summary:	Record and Replay Framework
Group:		Development/Debuggers
License:	MIT and BSD and Apache-2.0
URL:		https://rr-project.org/
Vcs:		https://github.com/rr-debugger/rr
# Upstream issue tracker: https://github.com/mozilla/rr/issues/

Source:		%name-%version.tar
ExclusiveArch:	x86_64 aarch64

Obsoletes:	rr-project < %EVR
Provides:	rr-project = %EVR
Requires:	gdb

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-cmake
BuildRequires: capnproto-devel
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: zlib-devel

%description
rr is a lightweight tool for recording, replaying and debugging execution
of applications (trees of processes and threads). Debugging extends gdb
with very efficient reverse-execution, which in combination with standard
gdb/x86 features like hardware data watchpoints, makes debugging much
more fun.

rr currently requires either:

- An Intel CPU with Nehalem (2010) or later microarchitecture.
- Certain AMD Zen or later processors.
- Certain AArch64 microarchitectures (e.g. ARM Neoverse N1 or the Apple
  Silicon M-series).

%prep
%setup

%build
# %%define optflags_lto %nil
# %%add_optflags -Wno-error=maybe-uninitialized
%cmake -Ddisable32bit=ON -DBUILD_TESTS=OFF
%cmake_build

%install
%cmake_install
rm -rf %buildroot%_datadir/rr/src

# By default, with `--strip-all` it strips `.replay.text` causing `rr replay` crash.
# https://github.com/rr-debugger/rr/issues/3364
%brp_strip_none %_libdir/rr/lib*.so

%files
%define _customdocdir %_docdir/%name
%doc LICENSE README.md scripts/zen_workaround.py
%_bindir/rr
%_bindir/rr_exec_stub
%_bindir/signal-rr-recording.sh
%_bindir/rr-collect-symbols.py
%_datadir/rr
%_datadir/bash-completion/completions/rr
%_libdir/rr

%changelog
