%define _unpackaged_files_terminate_build 1
%set_verify_elf_method unresolved=relaxed
%add_findprov_skiplist /%_lib/*
%add_debuginfo_skiplist /%_lib

%define rname samba
%define dcname samba-DC
%define _localstatedir /var

# If one of those versions change, we need to make sure we rebuilt or adapt
# projects comsuming those. This is e.g. sssd, openchange, evolution-mapi, ...
%define libdcerpc_binding_so_version 0
%define libdcerpc_server_core_so_version 0
%define libdcerpc_so_version 0
%define libndr_krb5pac_so_version 0
%define libndr_nbt_so_version 0
%define libndr_so_version 3
%define libndr_standard_so_version 0
%define libnetapi_so_version 1
%define libsamba_credentials_so_version 1
%define libsamba_errors_so_version 1
%define libsamba_hostconfig_so_version 0
%define libsamba_passdb_so_version 0
%define libsamba_util_so_version 0
%define libsamdb_so_version 0
%define libsmbconf_so_version 0
%define libsmbldap_so_version 2
%define libtevent_util_so_version 0

%define libsmbclient_so_version 0
%define libwbclient_so_version 0

# internal libs
%def_without talloc
%def_without tevent
%def_without tdb
%def_without ldb
%def_with    winbind

%def_with profiling_data
%def_with snapper

# build as separate package
%def_with libsmbclient
%def_with libwbclient
%def_without libnetapi
%def_with doc

%def_with dc
%def_without ntvfs
%def_with clustering_support
%def_without testsuite

%if_with testsuite
# The testsuite only works with a full build right now.
%force_with dc
%endif

%if_with dc
%def_with ldb_modules
%endif

%def_with mitkrb5
%def_with separate_heimdal_server
%def_with systemd
%def_enable avahi
%def_enable spotlight

%ifarch x86_64 aarch64 ppc64le
%def_with libcephfs
%def_enable cephfs
%else
%def_without libcephfs
%def_disable cephfs
%endif

%if_with clustering_support
%if_with libcephfs
%def_enable ceph_mutex
%else
%def_disable ceph_mutex
%endif
%ifarch %e2k
%def_disable pcp_pmda
%def_disable etcd_mutex
%else
%def_disable pcp_pmda
%def_enable etcd_mutex
%endif
%else
%def_disable ceph_mutex
%def_disable pcp_pmda
%def_disable etcd_mutex
%endif

%ifarch %e2k
%def_disable io_uring
%else
%def_enable io_uring
%endif

%ifarch %e2k armh
%def_disable glusterfs
%else
%def_enable glusterfs
%endif

%define _samba_libdir  %_libdir
%define _samba_libexecdir  %_libexecdir/samba
%define _samba_mod_libdir  %_libdir/samba
%define _samba_dc_libdir  %_libdir/samba-dc
%define _samba_dc_mod_libdir  %_libdir/samba-dc
%define _samba_dc_pythonarchdir  %_samba_dc_mod_libdir/python%_python3_version
%define _samba_piddir /run
%define _samba_sockets_dir /run/samba

%if_with separate_heimdal_server
%add_python3_compile_include %_samba_dc_mod_libdir/python%_python3_version
%add_python_compile_exclude %_samba_dc_mod_libdir/python%_python3_version
%endif

Name:    samba
Version: 4.19.9
Release: alt8

Group:   System/Servers
Summary: The Samba4 CIFS and AD client and server suite
License: GPLv3+ and LGPLv3+
Url:     http://www.samba.org/

Source:  %rname-%version.tar

# Red Hat specific replacement-files
Source1: samba.log
Source5: smb.init
Source6: samba.pamd
Source8: winbind.init
Source9: smb.conf.default
Source10: nmb.init
Source11: pam_winbind.conf
Source12: ctdb.init
Source13: samba.limits
Source20: samba.init
Source21: smbusers
Source22: smb.conf.example
Source23: usershares.conf
Source24: smb-conf-usershares.control
Source25: role-usershares.control
Source26: samba-usershares.role
Source27: role-sambashare.control
Source28: smb-conf-usershare-allow-list.control
Source29: smb-conf-usershare-deny-list.control
Source30: smb-conf-usershare-owner-only.control
Source31: smb-conf-usershare-allow-guests.control

Source200: README.dc
Source201: README.downgrade

Patch: %rname-%version-alt.patch
Patch10: samba-grouppwd.patch

Provides: samba4 = %version-%release
Obsoletes: samba4 < %version-%release
Provides: samba-swat = %version-%release
Obsoletes: samba-swat < %version-%release

# Need for samba_upgradedns
Requires: tdb-utils

Requires(pre): %name-common = %version-%release
Requires: %name-libs = %version-%release
Requires: %name-dcerpc = %version-%release
%if_with libwbclient
Requires: libwbclient = %version-%release
%endif

BuildRequires: alternatives
BuildRequires: /proc
BuildRequires: libe2fs-devel
BuildRequires: libacl-devel
BuildRequires: libattr-devel
BuildRequires: libgnutls-devel
BuildRequires: libncurses-devel
BuildRequires: libpam-devel
BuildRequires: perl-devel
BuildRequires: perl-Parse-Yapp
BuildRequires: perl-JSON
BuildRequires: libpopt-devel
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-alternatives
BuildRequires: python3-devel
BuildRequires: libreadline-devel
BuildRequires: libldap-devel
BuildRequires: zlib-devel
BuildRequires: libarchive-devel >= 3.1.2
BuildRequires: libjansson-devel
BuildRequires: libgpgme-devel
%if_with io_uring
BuildRequires: liburing-devel >= 0.4
%endif
BuildRequires: /usr/bin/rpcgen
BuildRequires: libtirpc-devel
BuildRequires: libtasn1-devel
BuildRequires: libtasn1-utils

%if_enabled pcp_pmda
BuildRequires: libpcp-devel
%endif
%if_enabled ceph_mutex
BuildRequires: librados-devel
%endif
%if_enabled etcd_mutex
BuildRequires: python3-module-etcd
%endif

%if_with mitkrb5
BuildRequires: libssl-devel
BuildRequires: libkrb5-devel
%if_with dc
BuildRequires: krb5-kdc
%endif
%endif

%if_with dc
BuildRequires: flex
BuildRequires: liblmdb-devel >= 0.9.16
BuildRequires: python3-module-markdown
BuildRequires: python3-module-dns
%endif

%if_with separate_heimdal_server
BuildRequires: perl-JSON-PP
%endif

BuildRequires: glibc-devel glibc-kernheaders
# https://bugzilla.samba.org/show_bug.cgi?id=9863
BuildConflicts: setproctitle-devel
BuildRequires: libiniparser-devel
BuildRequires: libcups-devel
BuildRequires: gawk libcap-devel libuuid-devel
%{?_with_doc:BuildRequires: libxslt xsltproc netpbm dblatex html2text docbook-style-xsl}

%if_with snapper
BuildRequires: libdbus-devel
%endif

%if_without talloc
BuildRequires: libtalloc-devel >= 2.4.1
BuildRequires: python3-module-talloc-devel
%endif

%if_without tevent
BuildRequires: libtevent-devel >= 0.15.0
BuildRequires: python3-module-tevent
%endif

%if_without tdb
BuildRequires: libtdb-devel >= 1.4.9
BuildRequires: python3-module-tdb
%endif

%if_without ldb
%define ldb_version 2.8.2
BuildRequires: libldb-devel = %ldb_version
BuildRequires: python3-module-pyldb-devel
%endif
%{?_with_testsuite:BuildRequires: ldb-tools}
%{?_with_systemd:BuildRequires: libsystemd-devel}
%{?_enable_avahi:BuildRequires: libavahi-devel}
%{?_enable_glusterfs:BuildRequires: libglusterfs-api-devel}
%{?_with_libcephfs:BuildRequires: ceph-devel}

# Build spotlight without tracker backend if enabled.
#{?_enable_spotlight:BuildRequires: tracker-devel}

%description
Samba is the standard Windows interoperability suite of programs for Linux and Unix.

%package -n admx-samba
Summary: Samba ADMX policy templates
Group: System/Configuration/Other
BuildArch: noarch

BuildRequires: admx-lint

%description -n admx-samba
admx-samba provides ADMX policy templates for Samba project.

%package dc-common
Summary: Files used by MIT and Heimdal Active Directory Domain Services servers
Group: System/Servers
BuildArch: noarch
Requires: admx-samba = %version-%release
Requires: lmdb-utils

%description dc-common
%rname-dc-common provides files necessary for both MIT and Heimdal
Active Directory Domain Services servers separately builded and packaged.

%package dc
Summary: Samba Active Directory Domain Controller with Heimdal Kerberos
Group: Networking/Other
Obsoletes: %dcname < %version-%release
Provides: %dcname = %version-%release
Requires: %name-dc-client = %version-%release
Requires: %name-dc-common = %version-%release
%if_without separate_heimdal_server
Requires: %name = %version-%release
Requires: %name-winbind = %version-%release
%if_with mitkrb5
Requires: krb5-kdc
%endif
%else
Requires: tdb-utils
Requires: %name-winbind-common = %version-%release
Requires(pre): %name-common = %version-%release
%endif
Conflicts: %name-dc-mitkrb5

# Workaround for unneeded python2.7 requires
%add_python_req_skip bisect
%add_python_req_skip ctypes
%add_python_req_skip json
%add_python_req_skip logging
%add_python_req_skip ldb
%add_python_req_skip tdb
%add_python_req_skip xml

%description dc
Samba as Active Directory Domain Services (AD DS) also called a domain controller,
build with Heimdal Kerberos server and libraries.

%package dc-mitkrb5
Summary: Samba Active Directory Domain Controller with MIT Kerberos
Group: Networking/Other
Requires: %name = %version-%release
Requires: %name-dc-client = %version-%release
Requires: %name-dc-common = %version-%release
Requires: %name-winbind = %version-%release
Requires: krb5-kdc
Conflicts: %name-dc

%description dc-mitkrb5
Samba as Active Directory Domain Services (AD DS) also called a domain controller,
build with MIT Kerberos server and libraries.

%package client
Summary: Samba client programs
Group: Networking/Other
Requires: %name-common-client = %version-%release
Provides: samba-utils = %version-%release
Provides: samba-client-cups = %version-%release
Obsoletes: samba-client-cups < %version-%release

%description client
The %rname-client package provides some SMB/CIFS clients to complement
the built-in SMB/CIFS filesystem in Linux. These clients allow access
of SMB/CIFS shares and printing to SMB/CIFS printers.

%package gpupdate
Summary: Samba GPO support for clients
Group: Networking/Other
%ifnarch loongarch64
Requires: cepces
%endif
Requires: certmonger
Requires: libldb-modules-ldap = %version-%release
Requires: python3-module-%name = %version-%release

%description gpupdate
This package provides the samba-gpupdate tool to apply Group Policy Objects
(GPO) on Samba clients.

%package dc-client
Summary: Samba Active Directory client programs
Group: Networking/Other
Requires: %name-client = %version-%release
Provides: %dcname-client = %version-%release
Obsoletes: %dcname-client < 4.10

%description dc-client
The %rname-client package provides Active Directory Domain Services clients.

%package common-client
Summary: Files used by both Samba clients
Group: System/Configuration/Other
BuildArch: noarch

%description common-client
%rname-common provides files necessary for both the client packages of Samba.

%package common
Summary: Files used by both Samba servers
Group: System/Servers
BuildArch: noarch
Requires: %name-common-client = %version-%release
Provides: %dcname-common = %version-%release
Obsoletes: %dcname-common < 4.10

%description common
%rname-common provides files necessary for both the server packages of Samba.

%package libs
Summary: Samba libraries
Group: System/Libraries
Requires: %name-common-libs = %version-%release
%if_without ldb
Requires: libldb = %ldb_version
%endif

%if_without libsmbclient
Provides: libsmbclient = %version-%release
Obsoletes: libsmbclient < %version-%release
%endif
%if_without libwbclient
Provides: libwbclient = %version-%release
Obsoletes: libwbclient < %version-%release
%endif
%if_without libnetapi
Provides: libnetapi = %version-%release
Obsoletes: libnetapi < %version-%release
%endif

%description libs
The %rname-libs package contains the libraries needed by programs that
link against the SMB, RPC and other protocols provided by the Samba suite.

%package vfs-cephfs
Summary: Samba VFS module for Ceph distributed storage system
Group: System/Libraries

%description vfs-cephfs
Samba VFS module for Ceph distributed storage system integration.

%package vfs-glusterfs
Summary: Samba VFS module for GlusterFS
Group: System/Libraries

%description vfs-glusterfs
Samba VFS module for GlusterFS integration.

%package vfs-snapper
Summary: Samba VFS module exposes snapshots managed by snapper as shadow-copies
Group: System/Libraries

%description vfs-snapper
Samba VFS module for exposes snapshots managed by snapper for use by Samba. This
provides the ability for remote SMB clients to access shadow-copies via Windows
Explorer using the "previous versions" dialog.

Snapshots can also be created and remove remotely, using the File Server Remote
VSS Protocol (FSRVP). Snapshot creation and deletion requests are forwarded to
snapper via DBus

%package krb5-printing
Summary: Samba CUPS backend for printing with Kerberos
Group: System/Configuration/Printing
Requires(pre): %name-client
Requires: %name-client = %version-%release

%description krb5-printing
If you need Kerberos for print jobs to a printer connection to cups via the SMB
backend, then you need to install that package. It will allow cups to access
the Kerberos credentials cache of the user issuing the print job.

%package dc-libs
Summary: Samba libraries
Group: System/Libraries
Provides: %dcname-libs = %version-%release
Obsoletes: %dcname-libs < 4.10
Provides: libldb-modules-DC = %version-%release
Obsoletes: libldb-modules-DC < 4.10
Provides: libldb-modules-dc = %version-%release
Obsoletes: libldb-modules-dc < 4.17

%if_with ldb_modules
Requires: libldb-modules-ldap = %version-%release
%endif

%description dc-libs
The %rname-libs package contains the libraries needed by programs that
link against the SMB, RPC and other protocols provided by the Samba suite.

%package common-libs
Summary: Samba common libraries
Group: System/Libraries
Provides: %dcname-common-libs = %version-%release
Obsoletes: %dcname-common-libs < 4.10
Provides: %rname-client-libs = %version-%release
Obsoletes: %rname-client-libs < 4.10

%description common-libs
The %rname-common-libs package contains the common libraries needed by modules that
link against the SMB, RPC and other protocols provided by the Samba suite.

%package common-tools
Summary: Tools for Samba servers and clients
Group: System/Servers
Requires: %name-common-client = %version-%release
Provides: %dcname-common-tools = %version-%release
Obsoletes: %dcname-common-tools < 4.10
Conflicts: gnustep-gworkspace

%description common-tools
The %rname-common-tools package contains tools for Samba servers and
SMB/CIFS clients.

%package -n libsmbclient
Summary: The SMB client library
Group: System/Libraries
Provides: libsmbclient-DC = %version-%release
Obsoletes: libsmbclient-DC < 4.10

%description -n libsmbclient
The libsmbclient contains the SMB client library from the Samba suite.

%package -n libldb-modules-ldap
Summary: Samba ldap modules for ldb
Group: System/Libraries
Requires: %name-libs = %version-%release
Provides: ldbsamba_extensions = %version-%release
Provides: %name-ldb-ldap-modules = %version-%release

%description -n libldb-modules-ldap
This package contains the ldb ldap modules required by samba-tool and
samba-gpupdate.

%package -n libsmbclient-devel
Summary: Developer tools for the SMB client library
Group: Development/C
Requires: libsmbclient = %version-%release
Provides: libsmbclient-DC-devel = %version-%release
Obsoletes: libsmbclient-DC-devel < 4.10

%description -n libsmbclient-devel
The libsmbclient-devel package contains the header files and libraries needed to
develop programs that link against the SMB client library in the Samba suite.

%package -n libwbclient
Summary: The winbind client library
Group: System/Libraries
Provides: libwbclient-DC = %version-%release
Obsoletes: libwbclient-DC < 4.10
Obsoletes: libwbclient-sssd

%description -n libwbclient
The libwbclient package contains the winbind client library from the Samba suite.

%package -n libwbclient-devel
Summary: Developer tools for the winbind library
Group: Development/C
Requires: libwbclient = %version-%release
Provides: libwbclient-DC-devel = %version-%release
Obsoletes: libwbclient-DC-devel < 4.10

%description -n libwbclient-devel
The libwbclient-devel package provides developer tools for the wbclient library.

%package -n libnetapi
Summary: Samba netapi library
Group: System/Libraries
Provides: libnetapi-DC = %version-%release
Obsoletes: libnetapi-DC < 4.10

%description -n libnetapi
Samba netapi library

%package -n libnetapi-devel
Summary: Samba netapi development files
Group: Development/Other
Requires: libnetapi = %version-%release
Conflicts: libnetapi-devel
Provides: libnetapi-DC-devel = %version-%release
Obsoletes: libnetapi-DC-devel < 4.10

%description -n libnetapi-devel
Samba netapi development files

%package -n python3-module-%name
Summary: Samba Python3 libraries
Group: Networking/Other
#Requires: %name-libs = %version-%release
Provides: python3-module-%dcname = %version-%release
Obsoletes: python3-module-%dcname < 4.10
Requires: %name-libs = %version-%release

# these modules currently don't support Python3 and aren't packaged
%add_python3_req_skip dsdb
%add_python3_req_skip param
%add_python3_req_skip passdb
%add_python3_req_skip samba.dsdb

%add_python3_req_skip samba._ldb
%add_python3_req_skip samba.auth
%add_python3_req_skip samba.credentials
%add_python3_req_skip samba.dcerpc.base
%add_python3_req_skip samba.dcerpc.dnsp
%add_python3_req_skip samba.dcerpc.drsuapi
%add_python3_req_skip samba.dcerpc.misc
%add_python3_req_skip samba.dcerpc.netlogon
%add_python3_req_skip samba.dcerpc.samr
%add_python3_req_skip samba.dcerpc.security
%add_python3_req_skip samba.gpo
%add_python3_req_skip samba.messaging
%add_python3_req_skip samba.net
%add_python3_req_skip samba.netbios
%add_python3_req_skip samba.ntstatus
%add_python3_req_skip samba.param
%add_python3_req_skip samba.posix_eadb
%add_python3_req_skip samba.registry
%add_python3_req_skip samba.security
%add_python3_req_skip samba.xattr_native
%add_python3_req_skip samba.xattr_tdb

# Python3 not fully migrated yet
%add_python3_req_skip ConfigParser
%add_python3_req_skip StringIO

%description -n python3-module-%name
The %rname-python3 package contains the Python3 libraries needed by programs
that use SMB, RPC and other Samba provided protocols in Python3 programs.

%package -n python3-module-%name-devel
Summary: Samba Python3 development libraries
Group: Development/Other
Requires: python3-module-%name = %version-%release

%description -n python3-module-%name-devel
The python3-module-%name package contains the Python3 libraries development files.

%package devel
Summary: Developer tools for Samba libraries
Group: Development/C
Requires: %name-libs = %version-%release
Provides: %dcname-devel = %version-%release
Obsoletes: %dcname-devel < 4.10

%if_without libsmbclient
Provides: libsmbclient-devel = %version-%release
Obsoletes: libsmbclient-devel < %version-%release
%endif
%if_without libwbclient
Provides: libwbclient-devel = %version-%release
Obsoletes: libwbclient-devel < %version-%release
%endif
%if_without libnetapi
Provides: libnetapi-devel = %version-%release
Obsoletes: libnetapi-devel < %version-%release
%endif

%description devel
The %rname-devel package contains the header files for the libraries
needed to develop programs that link against the SMB, RPC and other
libraries in the Samba suite.

%package pidl
Summary: Perl IDL compiler
Group: Development/Tools
BuildArch: noarch
# Requires: perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Provides: %dcname-pidl = %version-%release
Obsoletes: %dcname-pidl < 4.10

%description pidl
The %rname-pidl package contains the Perl IDL compiler used by Samba
and Wireshark to parse IDL and similar protocols

%package test
Summary: Testing tools for Samba servers and clients
Group: Development/Tools
Requires: %name = %version-%release
Requires: %name-common = %version-%release
%if_with winbind
Requires: %name-winbind = %version-%release
%endif
Provides: %dcname-test = %version-%release
Obsoletes: %dcname-test < 4.10

%description test
%rname-test provides testing tools for both the server and client
packages of Samba.

%package usershares
Summary: Provides support for non-root user shares
Group: System/Servers
PreReq: control
Requires: %name = %version-%release
Requires: %name-common-tools = %version-%release
Requires: libnss-role

%description usershares
Installing this package will provide a configuration file, group and
directories to support non-root user shares. You can configure them
as a user using the `net usershare` command.

%package winbind-common
Summary: Files used by MIT and Heimdal Winbind servers
Group: System/Servers
Requires: %name-common-client = %version-%release
Requires: %name-common = %version-%release

%description winbind-common
%rname-winbind-common provides files necessary for both MIT and Heimdal
Winbind servers separately builded and packaged.

%package winbind
Summary: Samba winbind
Group: System/Servers
Requires: %name-libs = %version-%release
Requires: %name-dcerpc = %version-%release
Requires: %name-winbind-common = %version-%release
Provides: %dcname-winbind = %version-%release
Obsoletes: %dcname-winbind < 4.10

%description winbind
The %rname-winbind package provides the winbind NSS library, and some
client tools.  Winbind enables Linux to be a full member in Windows
domains and to use Windows user and group accounts on Linux.

%package winbind-clients
Summary: Samba winbind clients
Group: System/Servers
Requires: %name-winbind = %version-%release
Provides: %dcname-winbind-clients = %version-%release
Obsoletes: %dcname-winbind-clients < 4.10

%description winbind-clients
The samba-winbind-clients package provides the NSS library and a PAM
module necessary to communicate to the Winbind Daemon

%package winbind-krb5-locator
Summary: Samba winbind krb5 locator
Group: System/Servers
Provides: %dcname-winbind-krb5-locator = %version-%release
Obsoletes: %dcname-winbind-krb5-locator < 4.10

%description winbind-krb5-locator
The winbind krb5 locator is a plugin for the system kerberos library to allow
the local kerberos library to use the same KDC as samba and winbind use

%package winbind-krb5-localauth
Summary: Samba winbind krb5 plugin for mapping user accounts
Group: System/Servers
Provides: %dcname-winbind-krb5-localauth = %version-%release
Obsoletes: %dcname-winbind-krb5-localauth < 4.10

%description winbind-krb5-localauth
The winbind krb5 localauth is a plugin that permits the MIT Kerberos libraries
that Kerberos principals can be validated against local user accounts.

%package dcerpc
Summary: DCE RPC binaries
Group: System/Servers
Requires: samba-libs = %version-%release

%description dcerpc
The samba-dcerpc package contains binaries that serve DCERPC over named pipes.

%package ctdb
Summary: A Clustered Database based on Samba's Trivial Database (TDB)
Group: System/Servers

# for ps and killall
Requires: psmisc
Requires: tdb-utils
# for pkill and pidof:
Requires: procps
# for netstat:
Requires: net-tools
Requires: ethtool
# for ip:
Requires: iproute
Requires: iptables
# for flock, getopt, kill:
Requires: util-linux
Provides: ctdb = %version-%release

%description ctdb
CTDB is a cluster implementation of the TDB database used by Samba and other
projects to store temporary data. If an application is already using TDB for
temporary data it is very easy to convert that application to be cluster aware
and use CTDB instead.

%package ctdb-pcp-pmda
Summary: CTDB PCP pmda support
Group: System/Servers
Requires: %name-ctdb = %version-%release
Provides: ctdb-pcp-pmda = %version-%release

%description ctdb-pcp-pmda
Performance Co-Pilot (PCP) support for CTDB

%package ctdb-etcd-mutex
Summary: CTDB ETCD mutex helper
Group: System/Servers
Requires: %name-ctdb = %version-%release
Provides: ctdb-etcd-mutex = %version-%release

%description ctdb-etcd-mutex
Support for using an existing ETCD cluster as a mutex helper for CTDB

%package ctdb-ceph-mutex
Summary: CTDB ceph mutex helper
Group: System/Servers
Requires: %name-ctdb = %version-%release
Provides: ctdb-ceph-mutex = %version-%release

%description ctdb-ceph-mutex
Support for using an existing CEPH cluster as a mutex helper for CTDB

%package ctdb-tests
Summary: CTDB clustered database test suite
Group: Development/Other
Requires: %name-ctdb = %version-%release
Requires: nc
Conflicts: ctdb-tests
Conflicts: ctdb-devel
Provides:  %name-ctdb-devel = %version-%release
Obsoletes: %name-ctdb-devel < %version-%release
Provides: %dcname-ctdb-tests = %version-%release
Obsoletes: %dcname-ctdb-tests < 4.10

%description ctdb-tests
Test suite for CTDB.
CTDB is a cluster implementation of the TDB database used by Samba and other
projects to store temporary data. If an application is already using TDB for
temporary data it is very easy to convert that application to be cluster aware
and use CTDB instead.

%package doc
Summary: Documentation for the Samba suite
Group: Documentation
Requires: %name-common = %version-%release
BuildArch: noarch
Provides: %dcname-doc = %version-%release
Obsoletes: %dcname-doc < 4.10

%description doc
The samba-doc package includes all the non-manpage documentation for the
Samba suite.

%package -n task-samba-dc
Summary: Complete Samba Active Directory Domain Controller with Heimdal Kerberos
Group: System/Servers
BuildArch: noarch
Provides: task-samba-ad-dc = %version-%release
Provides: task-ad-dc = %version-%release
Requires: samba-dc samba-winbind-clients %{?_with_doc:samba-doc} krb5-kinit ldb-tools

%description -n task-samba-dc
Samba server acts as a Domain Controller that is compatible with
Microsoft Active Directory.

%package -n task-samba-dc-mitkrb5
Summary: Complete Samba Active Directory Domain Controller with MIT Kerberos
Group: System/Servers
BuildArch: noarch
Requires: samba-dc-mitkrb5 %{?_with_doc:samba-doc} krb5-kinit ldb-tools

%description -n task-samba-dc-mitkrb5
Samba server acts as a Domain Controller that is compatible with
Microsoft Active Directory with MIT Kerberos server and libraries.

%package util-private-headers
Summary: libsamba_util private headers
Group: Development/C
Provides: %dcname-util-private-headers = %version-%release
Obsoletes: %dcname-util-private-headers < 4.10

%description util-private-headers
libsamba_util private headers.

%prep
%setup -q -n %rname-%version
%patch -p1
%patch10 -p1

%if_with separate_heimdal_server
rm -rf ../%rname-%version-separate-heimdal-server
cp -a ../%rname-%version ../%rname-%version-separate-heimdal-server
%endif

%build

%define _talloc_lib ,talloc,pytalloc,pytalloc-util
%if_without talloc
%define _talloc_lib ,!talloc,!pytalloc,!pytalloc-util
%endif

%define _tevent_lib ,tevent,pytevent
%if_without tevent
%define _tevent_lib ,!tevent,!pytevent
%endif

%define _tdb_lib ,tdb,pytdb
%if_without tdb
%define _tdb_lib ,!tdb,!pytdb
%endif

%define _ldb_lib ,ldb,pyldb,pyldb-util
%if_without ldb
%define _ldb_lib ,!ldb,!pyldb,!pyldb-util
%endif

%define _samba4_libraries heimdal,!zlib,!popt%{_talloc_lib}%{_tevent_lib}%{_tdb_lib}%{_ldb_lib}

%define _vfs_snapper_lib vfs_snapper
%if_without snapper
%define _vfs_snapper_lib !vfs_snapper
%endif

%define _samba4_idmap_modules idmap_ad,idmap_rid,idmap_adex,idmap_hash,idmap_tdb2
%define _samba4_pdb_modules pdb_tdbsam,pdb_ldap,pdb_ads,pdb_smbpasswd,pdb_wbc_sam,pdb_samba4
%define _samba4_auth_modules auth_unix,auth_wbc,auth_server,auth_netlogond,auth_script,auth_samba4
%define _samba4_vfs_modules %{_vfs_snapper_lib}
# auth_domain needs to be static
%define _samba4_modules %_samba4_idmap_modules,%_samba4_pdb_modules,%_samba4_auth_modules,%_samba4_vfs_modules

%define _libsmbclient %nil
%if_without libsmbclient
%define _libsmbclient smbclient,smbsharemodes,
%endif

%define _libwbclient %nil
%if_without libwbclient
%define _libwbclient wbclient,
%endif

%define _samba4_private_libraries %{_libsmbclient}%{_libwbclient}

%undefine _configure_gettext

%define configure_common() \
	%configure \\\
	--enable-fhs \\\
	--vendor-suffix=%release \\\
	--with-piddir=%_samba_piddir \\\
	--with-sockets-dir=%_samba_sockets_dir \\\
	--with-lockdir=%_localstatedir/lib/samba \\\
	--with-cachedir=%_localstatedir/cache/samba \\\
	--with-privatedir=/var/lib/samba/private \\\
	--with-shared-modules=%_samba4_modules \\\
	--bundled-libraries=%_samba4_libraries \\\
	--with-ads \\\
	--with-pie \\\
	--with-relro \\\
	--without-fam \\\
	--private-libraries=%_samba4_private_libraries \\\
%if_with systemd \
	--systemd-install-services \\\
	--with-systemddir=%_unitdir \\\
%endif \
%if_with winbind \
	--with-winbind \\\
%else \
	--without-winbind \\\
%endif \
%if_with testsuite \
	--enable-selftest \\\
%endif \
%if_with profiling_data \
	--with-profiling-data \\\
%endif \
	%{subst_enable spotlight} \\\
	%{subst_enable avahi} \\\
	%{subst_enable cephfs} \\\
	%{subst_enable glusterfs} \\\
	%*

%configure_common \
%if_with mitkrb5 \
	--with-system-mitkrb5 \
%endif \
%if_without dc \
	--without-ad-dc \
%else \
%if_with mitkrb5 \
	--with-experimental-mit-ad-dc \
%endif \
%if_with ntvfs \
	--with-ntvfs-fileserver \
%endif \
%endif \
%if_with clustering_support \
	--with-cluster-support \
%if_enabled pcp_pmda \
	--enable-pmda \
%endif \
%if_enabled etcd_mutex \
	--enable-etcd-reclock \
%endif \
%if_enabled ceph_mutex \
	--enable-ceph-reclock \
%endif \
%endif \
	--libdir=%_samba_libdir \
	--with-modulesdir=%_samba_mod_libdir \
	--with-privatelibdir=%_samba_mod_libdir \
	--with-pammodulesdir=/%_lib/security \
	--with-pam

%if_with separate_heimdal_server
pushd ../%rname-%version-separate-heimdal-server

%configure_common \
	--libdir=%_samba_dc_libdir \
	--libexecdir=%_samba_dc_libdir \
	--with-modulesdir=%_samba_dc_mod_libdir \
	--with-privatelibdir=%_samba_dc_mod_libdir \
	--pythonarchdir=%_samba_dc_pythonarchdir \
	--without-pam

%make_build NPROCS=%__nprocs V=2 -Onone

popd
%endif

%make_build NPROCS=%__nprocs V=2 -Onone

pushd pidl
%__perl Makefile.PL PREFIX=%_prefix

%make_build V=2 -Onone
popd

%if_with doc
pushd docs-xml
export XML_CATALOG_FILES="file:///etc/xml/catalog file://$(pwd)/build/catalog.xml"
%autoreconf
%configure
%make_build smbdotconf/parameters.all.xml V=2 -Onone
%make_build release V=2 -Onone
popd
%endif

%install
%if_without separate_heimdal_server
%makeinstall_std V=2 -Onone %_smp_mflags
%else
pushd ../%rname-%version-separate-heimdal-server

%makeinstall_std V=2 -Onone %_smp_mflags

popd

mkdir -p %buildroot%_altdir

mv %buildroot%_bindir %buildroot%_samba_dc_mod_libdir/bin
mv %buildroot%_sbindir %buildroot%_samba_dc_mod_libdir/sbin
for f in samba samba_kcc samba_dnsupdate samba_spnupdate samba_upgradedns eventlogadm nmbd smbd winbindd; do
    printf "%_sbindir/$f\t%_samba_dc_mod_libdir/sbin/$f\t50\n" >> %buildroot%_altdir/samba-heimdal
done
printf "%_bindir/wbinfo\t%_samba_dc_mod_libdir/bin/wbinfo\t50\n" >> %buildroot%_altdir/samba-heimdal
printf "%_bindir/ntlm_auth\t%_samba_dc_mod_libdir/bin/ntlm_auth\t50\n" >> %buildroot%_altdir/samba-heimdal
printf "%_bindir/pdbedit\t%_samba_dc_mod_libdir/bin/pdbedit\t50\n" >> %buildroot%_altdir/samba-heimdal
printf "%_samba_mod_libdir/ldb\t%_samba_dc_mod_libdir/ldb\t50\n" >> %buildroot%_altdir/samba-heimdal

printf "%_bindir/samba-tool-plus\t%_samba_dc_mod_libdir/bin/samba-tool-plus\t50\n" >> %buildroot%_altdir/samba-heimdal
printf "%_bindir/samba-tool\t%_samba_dc_mod_libdir/bin/samba-tool\t50\n" >> %buildroot%_altdir/samba-heimdal
chmod 0755 %buildroot%_samba_dc_mod_libdir/bin/samba-tool

printf "%_sbindir/samba_downgrade_db\t%_samba_dc_mod_libdir/sbin/samba_downgrade_db\t50\n" >> %buildroot%_altdir/samba-heimdal
chmod 0755 %buildroot%_samba_dc_mod_libdir/sbin/samba_downgrade_db

mkdir -p %buildroot%_libdir/krb5/plugins/libkrb5
touch %buildroot%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so
printf "%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so\t%_samba_dc_mod_libdir/krb5/winbind_krb5_locator.so\t50\n" >> %buildroot%_altdir/samba-heimdal
printf "%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so\t%_samba_dc_mod_libdir/krb5/async_dns_krb5_locator.so\t40\n" >> %buildroot%_altdir/samba-heimdal

%makeinstall_std V=2 -Onone %_smp_mflags

rm -f %buildroot%_altdir/samba-mit
touch %buildroot%_altdir/samba-mit
mkdir %buildroot%_samba_mod_libdir/sbin
for f in eventlogadm nmbd smbd; do
    mv %buildroot%_sbindir/$f %buildroot%_samba_mod_libdir/sbin/
    printf "%_sbindir/$f\t%_samba_mod_libdir/sbin/$f\t20\n" >> %buildroot%_altdir/samba-mit
done
for f in samba samba_kcc samba_dnsupdate samba_spnupdate samba_upgradedns; do
    mv %buildroot%_sbindir/$f %buildroot%_samba_mod_libdir/sbin/
    printf "%_sbindir/$f\t%_samba_mod_libdir/sbin/$f\t20\n" >> %buildroot%_altdir/samba-mit-dc
done

mkdir %buildroot%_samba_mod_libdir/bin
mv %buildroot%_bindir/wbinfo %buildroot%_samba_mod_libdir/bin/
mv %buildroot%_bindir/ntlm_auth %buildroot%_samba_mod_libdir/bin/
mv %buildroot%_sbindir/winbindd %buildroot%_samba_mod_libdir/sbin/
printf "%_sbindir/winbindd\t%_samba_mod_libdir/sbin/winbindd\t20\n" > %buildroot%_altdir/samba-mit-winbind
printf "%_bindir/wbinfo\t%_samba_mod_libdir/bin/wbinfo\t20\n" >> %buildroot%_altdir/samba-mit-winbind
printf "%_bindir/ntlm_auth\t%_samba_mod_libdir/bin/ntlm_auth\t20\n" >> %buildroot%_altdir/samba-mit-winbind

mv %buildroot%_bindir/pdbedit %buildroot%_samba_mod_libdir/bin/
printf "%_bindir/pdbedit\t%_samba_mod_libdir/bin/pdbedit\t20\n" > %buildroot%_altdir/samba-mit-common-tools

mv %buildroot%_samba_mod_libdir/ldb %buildroot%_samba_mod_libdir/ldb.mit
printf "%_samba_mod_libdir/ldb\t%_samba_mod_libdir/ldb.mit\t20\n" > %buildroot%_altdir/samba-mit-dc-modules

mv %buildroot%_bindir/samba-tool %buildroot%_samba_mod_libdir/bin/
printf "%_bindir/samba-tool\t%_samba_mod_libdir/bin/samba-tool\t20\n" > %buildroot%_altdir/samba-mit-dc-client
chmod 0755 %buildroot%_samba_mod_libdir/bin/samba-tool

mv %buildroot%_sbindir/samba_downgrade_db %buildroot%_samba_mod_libdir/sbin/
printf "%_sbindir/samba_downgrade_db\t%_samba_mod_libdir/sbin/samba_downgrade_db\t20\n" >> %buildroot%_altdir/samba-mit-dc-client
chmod 0755 %buildroot%_samba_mod_libdir/sbin/samba_downgrade_db

%endif

mkdir -p %buildroot/sbin
mkdir -p %buildroot/usr/{sbin,bin}
mkdir -p %buildroot/%_lib/security
mkdir -p %buildroot/var/lib/samba
mkdir -p %buildroot/var/lib/ctdb
mkdir -p %buildroot%_localstatedir/cache/samba
mkdir -p %buildroot/var/lib/samba/{private,winbindd_privileged,scripts,sysvol,drivers,usershares}
mkdir -p %buildroot/var/log/samba/old
mkdir -p %buildroot/var/spool/samba
mkdir -p %buildroot%_samba_piddir/winbindd
mkdir -p %buildroot%_samba_sockets_dir
mkdir -p %buildroot%_samba_mod_libdir
mkdir -p %buildroot%_pkgconfigdir
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot%_sysconfdir/{pam.d,logrotate.d,security,sysconfig}

mkdir -p %buildroot%_tmpfilesdir

# Install other stuff
install -m644 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/samba
install -m644 %SOURCE9 %buildroot%_sysconfdir/samba/smb.conf
install -m644 %SOURCE22 %buildroot%_sysconfdir/samba/smb.conf.example
install -m644 %SOURCE23 %buildroot%_sysconfdir/samba/usershares.conf
install -m644 %SOURCE11 %buildroot%_sysconfdir/security
install -m644 %SOURCE6 %buildroot%_sysconfdir/pam.d/samba
echo 127.0.0.1 localhost > %buildroot%_sysconfdir/samba/lmhosts
mkdir -p %buildroot%_sysconfdir/openldap/schema
install -m644 examples/LDAP/samba.schema %buildroot%_sysconfdir/openldap/schema/samba.schema
install -m755 packaging/printing/smbprint %buildroot%_bindir/smbprint
install -Dm755 %SOURCE24 %buildroot%_controldir/smb-conf-usershares
install -Dm755 %SOURCE28 %buildroot%_controldir/smb-conf-usershare-allow-list
install -Dm755 %SOURCE29 %buildroot%_controldir/smb-conf-usershare-deny-list
install -Dm755 %SOURCE30 %buildroot%_controldir/smb-conf-usershare-owner-only
install -Dm755 %SOURCE31 %buildroot%_controldir/smb-conf-usershare-allow-guests
install -Dm755 %SOURCE25 %buildroot%_controldir/role-usershares
install -Dm755 %SOURCE27 %buildroot%_controldir/role-sambashare
install -Dm644 %SOURCE26 %buildroot%_sysconfdir/role.d/samba-usershares.role

cp packaging/systemd/samba.sysconfig packaging/systemd/samba.sysconfig.alt
echo "KRB5CCNAME=FILE:/run/samba/krb5cc_samba" >>packaging/systemd/samba.sysconfig.alt
install -m644 packaging/systemd/samba.sysconfig.alt %buildroot%_sysconfdir/sysconfig/samba
install -m644 %SOURCE21 %buildroot%_sysconfdir/samba/smbusers

install -m755 %SOURCE10 %buildroot%_initrddir/nmb
install -m755 %SOURCE5 %buildroot%_initrddir/smb
install -m755 %SOURCE8 %buildroot%_initrddir/winbind
%if_with dc
install -m755 %SOURCE20 %buildroot%_initrddir/samba
%endif

# Put README in builddir
cp %SOURCE200 %SOURCE201 .

%if_with clustering_support
install -m755 %SOURCE12 %buildroot%_initrddir/ctdb
echo "d %_samba_piddir/ctdb 755 root root" >> %buildroot%_tmpfilesdir/ctdb.conf
touch %buildroot%_sysconfdir/ctdb/nodes
%endif

echo "d %_samba_piddir/samba 755 root root" > %buildroot%_tmpfilesdir/%rname.conf

# NetworkManager online/offline script
install -d -m 0755 %buildroot%_sysconfdir/NetworkManager/dispatcher.d/
install -m 0755 packaging/NetworkManager/30-winbind-systemd \
            %buildroot%_sysconfdir/NetworkManager/dispatcher.d/30-winbind

pushd pidl
make DESTDIR=%buildroot install_vendor

# Clean out crap left behind by the PIDL install.
find %buildroot -type f -name .packlist -exec rm -f {} \;
rm -f %buildroot%perl_vendorlib/wscript_build
rm -f %buildroot%perl_vendor_archlib/perllocal.pod
popd

# winbind
%if_with winbind
mkdir -p %buildroot/%_lib

mkdir -p %buildroot%_libdir/krb5/plugins/libkrb5
touch %buildroot%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so
printf "%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so\t%_samba_mod_libdir/krb5/winbind_krb5_locator.so\t20\n" >> %buildroot%_altdir/samba-mit-winbind-krb5-locator
printf "%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so\t%_samba_mod_libdir/krb5/async_dns_krb5_locator.so\t10\n" >> %buildroot%_altdir/samba-mit-winbind-krb5-locator
%if_with mitkrb5
mv %buildroot%_samba_mod_libdir/krb5/winbind_krb5_localauth.so %buildroot%_libdir/krb5/plugins/libkrb5/
%endif
%endif

#cups backend
%define cups_serverbin %(cups-config --serverbin 2>/dev/null)
mkdir -p %buildroot%cups_serverbin/backend
ln -s %_bindir/smbspool %buildroot%cups_serverbin/backend/smb

printf "%cups_serverbin/backend/smb\t%_bindir/smbspool\t20\n" > %buildroot%_altdir/samba-printing
printf "%cups_serverbin/backend/smb\t%_samba_libexecdir/smbspool_krb5_wrapper\t50\n" > %buildroot%_altdir/samba-krb5-printing

# Fix up permission on perl install.
%_fixperms %buildroot%perl_vendor_privlib

# remove tests form python modules
rm -rf %buildroot%python3_sitelibdir/samba/{tests,subunit,external/subunit,external/testtool}
rm -f %buildroot%python3_sitelibdir/samba/third_party/iso8601/test_*.py
%if_with separate_heimdal_server
rm -rf %buildroot%_samba_dc_mod_libdir/python%_python3_version/samba/{tests,subunit,external/subunit,external/testtool}
rm -f %buildroot%_samba_dc_mod_libdir/python%_python3_version/samba/third_party/iso8601/test_*.py
%endif

# remove cmocka library
rm -f %buildroot%_samba_mod_libdir/libcmocka-samba4.so
%if_with separate_heimdal_server
rm -f %buildroot%_samba_dc_mod_libdir/libcmocka-samba4.so
%endif

# move pkgconfig to standart path:
[ "%_libdir" != "%_samba_libdir" ] && mv %buildroot{%_samba_libdir/pkgconfig,%_libdir}

# Install documentation
%if_with doc
mkdir -p %buildroot%_defaultdocdir/%rname/
cp -a docs-xml/output/htmldocs %buildroot%_defaultdocdir/%rname/
%endif

# Cleanup man pages
%if_without libsmbclient
/bin/rm -f %buildroot%_man7dir/libsmbclient.7*
%endif

# Copy libsamba_util private headers
mkdir -p %buildroot%_includedir/samba-4.0/private/lib/util/charset
cp lib/util/*.h %buildroot%_includedir/samba-4.0/private/lib/util
cp lib/util/charset/*.h %buildroot%_includedir/samba-4.0/private/lib/util/charset
mkdir -p %buildroot%_includedir/samba-4.0/private/libcli/util
cp libcli/util/*.h %buildroot%_includedir/samba-4.0/private/libcli/util
subst 's,\.\./,,' %buildroot%_includedir/samba-4.0/private/lib/util/*.h

# Install limits
mkdir -p %buildroot%_sysconfdir/security/limits.d/
install -m644 %SOURCE13 %buildroot%_sysconfdir/security/limits.d/90-samba.conf

# Install traffic tools
install -m755 script/traffic_learner %buildroot%_bindir/traffic_learner
install -m755 script/traffic_replay %buildroot%_bindir/traffic_replay
#install -m755 script/traffic_summary.pl %buildroot%_bindir/traffic_summary (perl-XML-Twig requires)

# Compatiblity symlink for admx policy templates
#ln -s ../PolicyDefinitions %buildroot%_datadir/samba/admx

# Prepare to validation admx policy templates
for file in %buildroot%_datadir/PolicyDefinitions/*.admx %buildroot%_datadir/PolicyDefinitions/*-*/*.adml; do
    grep -q "^\(<policyDefinitions\|<policyDefinitionResources\) .*xmlns:xsd=" "$file" ||
        sed -i 's/^\(<policyDefinitions\|<policyDefinitionResources\)/\1 xmlns:xsd="http:\/\/www.w3.org\/2001\/XMLSchema"/' "$file"
    grep -q "^\(<policyDefinitions\|<policyDefinitionResources\) .*xmlns:xsi=" "$file" ||
        sed -i 's/^\(<policyDefinitions\|<policyDefinitionResources\)/\1 xmlns:xsi="http:\/\/www.w3.org\/2001\/XMLSchema-instance"/' "$file"
    grep -q "^\(<policyDefinitions\|<policyDefinitionResources\) .*xmlns=" "$file" ||
        sed -i 's/^\(<policyDefinitions\|<policyDefinitionResources\)/\1 xmlns="http:\/\/schemas.microsoft.com\/GroupPolicy\/2006\/07\/PolicyDefinitions"/' "$file"
done

# Provide compatiblity with __init__ function for samba.gp.* classes
touch %buildroot%python3_sitelibdir/samba/gp/__init__.py
touch %buildroot%python3_sitelibdir/samba/gp/util/__init__.py

# Generate .mo files for localization
pushd %_builddir/%rname-%version/source3/locale/

for domain in */; do
    pushd "$domain"

    for i in *.po; do
       lang="$(echo "$i" | cut -d '.' -f 1)"
       domain_name="$(echo "$domain" | cut -d '/' -f 1)"

       mkdir -p "%buildroot%_datadir/locale/${lang}/LC_MESSAGES/"
       msgfmt --output-file="%buildroot%_datadir/locale/${lang}/LC_MESSAGES/${domain_name}.mo" "%_builddir/%rname-%version/source3/locale/${domain}${i}"
    done

    popd
done

popd

%find_lang pam_winbind
%find_lang net

%check
for file in \
            %buildroot%_datadir/PolicyDefinitions/*.admx \
            %buildroot%_datadir/PolicyDefinitions/*/*.adml
do
    admx-lint --input_file "$file"
done

%if_with testsuite
TDB_NO_FSYNC=1 %make_build test V=2 -Onone
%endif

%post
%post_service smb
%post_service nmb

%preun
%preun_service smb
%preun_service nmb

%pre common
%_sbindir/groupadd -f -r printadmin >/dev/null 2>&1 || :

%if_with dc
%post dc
%post_service samba

%preun dc
%preun_service samba
%endif

%if_with winbind
%pre winbind-common
%_sbindir/groupadd -f -r wbpriv >/dev/null 2>&1 || :

%post winbind
%post_service winbind

%preun winbind
%preun_service winbind
%endif

%pre usershares
%_sbindir/groupadd -f -r usershares >/dev/null 2>&1 || :

# Enable sambashare group as role with usershares priviledge for compatility
# during upgrade from previous manual managed installations.
%triggerin -n %name-usershares -- %name < 4.16.7-alt4
control role-sambashare enabled

%files
%doc COPYING README.md WHATSNEW.txt
%doc examples/autofs examples/LDAP examples/misc
%doc examples/printer-accounting examples/printing
%doc README.downgrade
%if_with separate_heimdal_server
%_altdir/samba-mit
%_samba_mod_libdir/sbin/eventlogadm
%_samba_mod_libdir/sbin/nmbd
%_samba_mod_libdir/sbin/smbd
%else
%_sbindir/eventlogadm
%_sbindir/nmbd
%_sbindir/smbd
%endif
%_samba_libexecdir/samba-bgqd
%config(noreplace) %_sysconfdir/samba/smbusers
%attr(755,root,root) %_initdir/smb
%attr(755,root,root) %_initdir/nmb
%_unitdir/nmb.service
%_unitdir/smb.service

%dir %_samba_mod_libdir/vfs
%_samba_mod_libdir/vfs/*.so

%if_with libcephfs
%exclude %_samba_mod_libdir/vfs/ceph*.so
%endif

%if_enabled glusterfs
%exclude %_samba_mod_libdir/vfs/glusterfs.so
%endif

%if_with snapper
%exclude %_samba_mod_libdir/vfs/snapper.so
%endif

%dir %_samba_mod_libdir/auth
%_samba_mod_libdir/auth/unix.so

%attr(775,root,printadmin) %dir /var/lib/samba/drivers

%files dcerpc
%dir %_samba_libexecdir
%_samba_libexecdir/samba-dcerpcd
%_samba_libexecdir/rpcd_classic
%_samba_libexecdir/rpcd_epmapper
%_samba_libexecdir/rpcd_fsrvp
%_samba_libexecdir/rpcd_lsad
%_samba_libexecdir/rpcd_mdssvc
%_samba_libexecdir/rpcd_spoolss
%_samba_libexecdir/rpcd_winreg
%if_with doc
%_man8dir/samba-dcerpcd.8*
%endif

%if_with dc
%files -n admx-samba
%_datadir/PolicyDefinitions/*.admx
%_datadir/PolicyDefinitions/*/*.adml

%files dc-common
%dir /var/lib/samba/sysvol
%dir %_datadir/samba/setup
%_datadir/samba/setup
%if_with doc
%_man8dir/samba.8*
%endif #doc

%files dc
%attr(755,root,root) %_initdir/samba
%_unitdir/samba.service
%if_without separate_heimdal_server
%_sbindir/samba
%_sbindir/samba_kcc
%_sbindir/samba_dnsupdate
%_sbindir/samba_spnupdate
%_sbindir/samba_upgradedns
%_sbindir/samba_downgrade_db
%else #!separate_heimdal_server
%_unitdir/winbind.service
%attr(755,root,root) %_initrddir/winbind
%_sysconfdir/NetworkManager/dispatcher.d/30-winbind
%doc COPYING README.md WHATSNEW.txt
%doc examples/autofs examples/LDAP examples/misc
%doc examples/printer-accounting examples/printing
%_altdir/samba-heimdal
#_samba_dc_mod_libdir/sbin/eventlogadm
#_samba_dc_mod_libdir/sbin/nmbd
#_samba_dc_mod_libdir/sbin/smbd
#_samba_dc_mod_libdir/sbin/samba
#_samba_dc_mod_libdir/sbin/samba_kcc
#_samba_dc_mod_libdir/sbin/samba_dnsupdate
#_samba_dc_mod_libdir/sbin/samba_spnupdate
#_samba_dc_mod_libdir/sbin/samba_upgradedns
#_samba_dc_mod_libdir/sbin/winbindd
#_samba_dc_mod_libdir/bin/
%dir %_samba_dc_mod_libdir
%_samba_dc_libdir/
%ghost %_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so

%files -n task-samba-dc-mitkrb5

%files dc-mitkrb5
%attr(755,root,root) %_initdir/samba
%_unitdir/samba.service
%_altdir/samba-mit-dc
%_samba_mod_libdir/sbin/samba
%_samba_mod_libdir/sbin/samba_kcc
%_samba_mod_libdir/sbin/samba_dnsupdate
%_samba_mod_libdir/sbin/samba_spnupdate
%_samba_mod_libdir/sbin/samba_upgradedns
%endif #!separate_heimdal_server

%_samba_mod_libdir/auth/samba4.so

%files gpupdate
%_sbindir/samba-gpupdate
%if_with doc
%_man8dir/samba-gpupdate.8*
%endif

%files dc-client
%if_with separate_heimdal_server
%_altdir/samba-mit-dc-client
%_samba_mod_libdir/bin/samba-tool
%_samba_mod_libdir/sbin/samba_downgrade_db
%else
%_bindir/samba-tool
%_sbindir/samba_downgrade_db
%endif
%if_with doc
%_man8dir/samba-tool.8*
%_man8dir/samba_downgrade_db.8*
%endif #doc
%endif #dc

%files krb5-printing
%_altdir/samba-krb5-printing
%attr(0700,root,root) %_samba_libexecdir/smbspool_krb5_wrapper
%if_with doc
%_man8dir/smbspool_krb5_wrapper.8*
%endif

%files client
%_bindir/cifsdd
%_bindir/dbwrap_tool
%_bindir/dumpmscat
%_bindir/mdsearch
%_bindir/mvxattr
%_bindir/nmblookup
%_bindir/oLschema2ldif
%_bindir/regdiff
%_bindir/regpatch
%_bindir/regshell
%_bindir/regtree
%_bindir/rpcclient
%_bindir/samba-regedit
%_bindir/sharesec
%_bindir/smbcacls
%_bindir/smbclient
%_bindir/smbcquotas
%_bindir/smbget
%_bindir/smbpasswd
%_bindir/smbprint
%_bindir/smbspool
#_bindir/smbta-util
%_bindir/smbtar
%_bindir/smbtree
%_altdir/samba-printing
# Samba CUPS backend for printing with Kerberos support or not controlled
# by whether the samba-krb5-printing package is installed or not:
#  %_bindir/smbspool or %_samba_libexecdir/smbspool_krb5_wrapper
#   -> %cups_serverbin/backend/smb
%ghost %cups_serverbin/backend/smb
%if_with doc
%_man1dir/dbwrap_tool.1*
%_man1dir/mdsearch.1*
%_man1dir/mvxattr.1*
%_man1dir/nmblookup.1*
%_man1dir/oLschema2ldif.1*
%_man1dir/regdiff.1*
%_man8dir/samba-regedit.8*
%_man1dir/regpatch.1*
%_man1dir/regshell.1*
%_man1dir/regtree.1*
%_man1dir/log2pcap.1*
%_man1dir/rpcclient.1*
%_man1dir/sharesec.1*
%_man1dir/smbcacls.1*
%_man1dir/smbclient.1*
%_man1dir/smbcquotas.1*
%_man1dir/smbget.1*
%exclude %_man1dir/smbtar.1*
%_man1dir/smbtree.1*
%_man5dir/smbpasswd.5*
%_man8dir/smbpasswd.8*
%_man8dir/smbspool.8*
#_man8dir/smbta-util.8*
%_man8dir/cifsdd.8*
%endif

%if_with tdb
%_bindir/tdbbackup
%_bindir/tdbdump
%_bindir/tdbrestore
%_bindir/tdbtool
%if_with doc
%_man8dir/tdbbackup.8*
%_man8dir/tdbdump.8*
%_man8dir/tdbrestore.8*
%_man8dir/tdbtool.8*
%endif #doc
%endif #tdb

%if_with ldb
%_bindir/ldbadd
%_bindir/ldbdel
%_bindir/ldbedit
%_bindir/ldbmodify
%_bindir/ldbrename
%_bindir/ldbsearch
%if_with doc
%_man1dir/ldbadd.1*
%_man1dir/ldbdel.1*
%_man1dir/ldbedit.1*
%_man1dir/ldbmodify.1*
%_man1dir/ldbrename.1*
%_man1dir/ldbsearch.1*
%endif
%_samba_mod_libdir/libldb-cmdline-samba4.so
%endif

%files common-client
%attr(755,root,root) %dir %_sysconfdir/samba
%config(noreplace) %_sysconfdir/samba/smb.conf
%_sysconfdir/samba/smb.conf.example
%config(noreplace) %_sysconfdir/samba/lmhosts

%if_with doc
%_man5dir/lmhosts.5*
%_man5dir/smb.conf.5*
%endif

%files common
%_sysconfdir/pam.d/samba
%dir /var/lib/samba
%attr(710,root,root) %dir /var/lib/samba/private
%_tmpfilesdir/%rname.conf
%config(noreplace) %_sysconfdir/logrotate.d/samba
%config(noreplace) %_sysconfdir/security/limits.d/90-samba.conf
%attr(0700,root,root) %dir /var/log/samba
%attr(0700,root,root) %dir /var/log/samba/old
%dir %_samba_sockets_dir
%attr(755,root,root) %dir %_localstatedir/cache/samba
%config(noreplace) %_sysconfdir/sysconfig/samba
%attr(1777,root,root) %dir /var/spool/samba
%_sysconfdir/openldap/schema/samba.schema

%dir %_datadir/samba
%if_enabled spotlight
%dir %_datadir/samba/mdssvc
%_datadir/samba/mdssvc/elasticsearch_mappings.json
%endif

%if_with doc
%_man7dir/samba.7*

%_man8dir/eventlogadm.8*
%_man8dir/smbd.8*
%_man8dir/nmbd.8*
%_man8dir/samba-bgqd.8*
%_man8dir/vfs_*.8*

%if_with libcephfs
%exclude %_man8dir/vfs_ceph.8*
%exclude %_man8dir/vfs_ceph_snapshots.8*
%endif
%if_enabled glusterfs
%exclude %_man8dir/vfs_glusterfs.8*
%endif
%if_with snapper
%exclude %_man8dir/vfs_snapper.8*
%endif
%endif #doc

%files common-tools -f net.lang
%_bindir/net
%if_with separate_heimdal_server
%_altdir/samba-mit-common-tools
%_samba_mod_libdir/bin/pdbedit
%else
%_bindir/pdbedit
%endif
%_bindir/profiles
%_bindir/samba-log-parser
%_bindir/smbcontrol
%_bindir/smbstatus
%_bindir/testparm
%if_with doc
%_man1dir/profiles.1*
%_man1dir/samba-log-parser.1*
%_man1dir/smbcontrol.1*
%_man1dir/smbstatus.1*
%_man1dir/testparm.1*
%_man8dir/net.8*
%_man8dir/pdbedit.8*
%endif #doc

%files devel
%dir %_includedir/samba-4.0
%_includedir/samba-4.0

%exclude %_includedir/samba-4.0/private
#%exclude %_includedir/samba-4.0/torture.h

%if_with libnetapi
%exclude %_includedir/samba-4.0/netapi.h
%else
%_samba_libdir/libnetapi.so
%_pkgconfigdir/netapi.pc
%endif

%if_with libsmbclient
%exclude %_includedir/samba-4.0/libsmbclient.h
%endif
%if_with libwbclient
%exclude %_includedir/samba-4.0/wbclient.h
%endif

%_samba_libdir/libdcerpc-binding.so
%_samba_libdir/libdcerpc-samr.so
%_samba_libdir/libdcerpc.so
%_samba_libdir/libndr-krb5pac.so
%_samba_libdir/libndr-nbt.so
%_samba_libdir/libndr-standard.so
%_samba_libdir/libndr.so
%_samba_libdir/libsamba-credentials.so
%_samba_libdir/libsamba-errors.so
%_samba_libdir/libsamba-hostconfig.so
%_samba_libdir/libsamba-util.so
%_samba_libdir/libsamdb.so
%_samba_libdir/libsmbconf.so
%_samba_libdir/libtevent-util.so
%_samba_libdir/libsamba-passdb.so
%_samba_libdir/libsmbldap.so

%_pkgconfigdir/dcerpc.pc
%_pkgconfigdir/dcerpc_samr.pc
%_pkgconfigdir/ndr.pc
%_pkgconfigdir/ndr_krb5pac.pc
%_pkgconfigdir/ndr_nbt.pc
%_pkgconfigdir/ndr_standard.pc
%_pkgconfigdir/samba-credentials.pc
%_pkgconfigdir/samba-hostconfig.pc
%_pkgconfigdir/samba-util.pc
%_pkgconfigdir/samdb.pc

%if_with dc
%_samba_libdir/libdcerpc-server-core.so
%_samba_libdir/libdcerpc-server.so
%_pkgconfigdir/dcerpc_server.pc
%endif

%files common-libs
%_samba_libdir/libdcerpc-samr.so.*
%_samba_libdir/libdcerpc-binding.so.%{libdcerpc_binding_so_version}*
%_samba_libdir/libndr-krb5pac.so.%{libndr_krb5pac_so_version}*
%_samba_libdir/libndr-nbt.so.%{libndr_nbt_so_version}*
%_samba_libdir/libndr-standard.so.%{libndr_standard_so_version}*
%_samba_libdir/libndr.so.%{libndr_so_version}*
%_samba_libdir/libsamba-credentials.so.%{libsamba_credentials_so_version}*
%_samba_libdir/libsamba-errors.so.%{libsamba_errors_so_version}*
%_samba_libdir/libsamba-hostconfig.so.%{libsamba_hostconfig_so_version}*
%_samba_libdir/libsamba-util.so.%{libsamba_util_so_version}*
%_samba_libdir/libsamdb.so.%{libsamdb_so_version}*
%_samba_libdir/libsmbconf.so.%{libsmbconf_so_version}*
%_samba_libdir/libsmbldap.so.%{libsmbldap_so_version}*
%_samba_libdir/libtevent-util.so.%{libtevent_util_so_version}*

# common libraries
%_samba_mod_libdir/libCHARSET3-samba4.so
%_samba_mod_libdir/libLIBWBCLIENT-OLD-samba4.so
%_samba_mod_libdir/libMESSAGING-SEND-samba4.so
%_samba_mod_libdir/libaddns-samba4.so
%_samba_mod_libdir/libasn1util-samba4.so
%_samba_mod_libdir/libauth-unix-token-samba4.so
%_samba_mod_libdir/libauthkrb5-samba4.so
%_samba_mod_libdir/libcli-cldap-samba4.so
%_samba_mod_libdir/libcli-ldap-common-samba4.so
%_samba_mod_libdir/libcli-ldap-samba4.so
%_samba_mod_libdir/libcli-nbt-samba4.so
%_samba_mod_libdir/libcliauth-samba4.so
%_samba_mod_libdir/libclidns-samba4.so
%_samba_mod_libdir/libcluster-samba4.so
%_samba_mod_libdir/libcmdline-samba4.so
%_samba_mod_libdir/libcmdline-contexts-samba4.so
%_samba_mod_libdir/libcommon-auth-samba4.so
%if_with clustering_support
%_samba_mod_libdir/libctdb-event-client-samba4.so
%endif
%_samba_mod_libdir/libdbwrap-samba4.so
%_samba_mod_libdir/libdcerpc-samba-samba4.so
%if_with dc
%_samba_mod_libdir/libdfs-server-ad-samba4.so
%endif
%_samba_mod_libdir/libevents-samba4.so
%_samba_mod_libdir/libflag-mapping-samba4.so
%_samba_mod_libdir/libgenrand-samba4.so
%_samba_mod_libdir/libgensec-samba4.so
%_samba_mod_libdir/libinterfaces-samba4.so
%_samba_mod_libdir/libiov-buf-samba4.so
%_samba_mod_libdir/libkrb5samba-samba4.so
%_samba_mod_libdir/libldbsamba-samba4.so
%_samba_mod_libdir/liblibcli-lsa3-samba4.so
%_samba_mod_libdir/libmessages-dgm-samba4.so
%_samba_mod_libdir/libmessages-util-samba4.so
%_samba_mod_libdir/libmsghdr-samba4.so
%_samba_mod_libdir/libndr-samba4.so
%_samba_mod_libdir/libndr-samba-samba4.so
%_samba_mod_libdir/libnetif-samba4.so
%_samba_mod_libdir/libnpa-tstream-samba4.so
%_samba_mod_libdir/libposix-eadb-samba4.so
%if_without libwbclient
%_samba_mod_libdir/libreplace-samba4.so
%_samba_mod_libdir/libwbclient.so.*
%endif
%_samba_mod_libdir/libsamba-cluster-support-samba4.so
%_samba_mod_libdir/libsamba-debug-samba4.so
%_samba_mod_libdir/libsamba-modules-samba4.so
%_samba_mod_libdir/libsamba-security-samba4.so
%_samba_mod_libdir/libsamba-sockets-samba4.so
%_samba_mod_libdir/libsamba3-util-samba4.so
%_samba_mod_libdir/libsamdb-common-samba4.so
%_samba_mod_libdir/libsecrets3-samba4.so
%_samba_mod_libdir/libserver-id-db-samba4.so
%_samba_mod_libdir/libserver-role-samba4.so
%_samba_mod_libdir/libshares-samba4.so
%_samba_mod_libdir/libsmb-transport-samba4.so
%_samba_mod_libdir/libsmbd-shim-samba4.so
%_samba_mod_libdir/libsmbpasswdparser-samba4.so
%_samba_mod_libdir/libstable-sort-samba4.so
%_samba_mod_libdir/libsocket-blocking-samba4.so
%_samba_mod_libdir/libsys-rw-samba4.so
%_samba_mod_libdir/libtalloc-report-printf-samba4.so
%_samba_mod_libdir/libtalloc-report-samba4.so
%_samba_mod_libdir/libtdb-wrap-samba4.so
%_samba_mod_libdir/libtime-basic-samba4.so
%_samba_mod_libdir/libtorture-samba4.so
%_samba_mod_libdir/libutil-reg-samba4.so
%_samba_mod_libdir/libutil-setid-samba4.so
%_samba_mod_libdir/libutil-tdb-samba4.so
%_samba_mod_libdir/libxattr-tdb-samba4.so

%files libs
# libraries needed by the public libraries
%_samba_libdir/libdcerpc.so.%{libdcerpc_so_version}*
%_samba_libdir/libdcerpc-server-core.so.%{libdcerpc_server_core_so_version}*
%_samba_libdir/libsamba-passdb.so.%{libsamba_passdb_so_version}*

%dir %_samba_mod_libdir/pdb
%_samba_mod_libdir/pdb

%_samba_mod_libdir/libREG-FULL-samba4.so
%_samba_mod_libdir/libRPC-SERVER-LOOP-samba4.so
%_samba_mod_libdir/libRPC-WORKER-samba4.so

%_samba_mod_libdir/libMESSAGING-samba4.so
%_samba_mod_libdir/libads-samba4.so
%_samba_mod_libdir/libauth-samba4.so
%_samba_mod_libdir/libcli-smb-common-samba4.so
%_samba_mod_libdir/libcli-spoolss-samba4.so
%_samba_mod_libdir/libdcerpc-pkt-auth-samba4.so
%_samba_mod_libdir/libdcerpc-samba4.so
%_samba_mod_libdir/libgpext-samba4.so
%_samba_mod_libdir/libgpo-samba4.so
%_samba_mod_libdir/libgse-samba4.so
%_samba_mod_libdir/libhttp-samba4.so
%_samba_mod_libdir/liblibcli-netlogon3-samba4.so
%_samba_mod_libdir/liblibsmb-samba4.so
%_samba_mod_libdir/libmscat-samba4.so
%_samba_mod_libdir/libmsrpc3-samba4.so
%_samba_mod_libdir/libnet-keytab-samba4.so

%_samba_mod_libdir/libprinter-driver-samba4.so
%_samba_mod_libdir/libprinting-migrate-samba4.so
%_samba_mod_libdir/libregistry-samba4.so
%_samba_mod_libdir/libsmbclient-raw-samba4.so
%_samba_mod_libdir/libsmbldaphelper-samba4.so
%_samba_mod_libdir/libsmbd-base-samba4.so
%_samba_mod_libdir/libtrusts-util-samba4.so

%if_with ldb
%_samba_libdir/libldb.so.*
%_samba_libdir/libpyldb-util.so.*
%endif
%if_with talloc
%_samba_libdir/libtalloc.so.*
%_samba_libdir/libpytalloc-util.so.*
%endif
%if_with tevent
%_samba_libdir/libtevent.so.*
%endif
%if_with tdb
%_samba_libdir/libtdb.so.*
%endif

%if_without libsmbclient
%_samba_mod_libdir/libsmbclient.so
%endif
%if_without libwbclient
%_samba_mod_libdir/libwbclient.so
%endif
%if_without libnetapi
%_samba_libdir/libnetapi.so.*
%endif

%if_with libcephfs
%files vfs-cephfs
%_samba_mod_libdir/vfs/ceph*.so
%if_with doc
%_man8dir/vfs_ceph.8*
%_man8dir/vfs_ceph_snapshots.8*
%endif
%endif

%if_enabled glusterfs
%files vfs-glusterfs
%_samba_mod_libdir/vfs/glusterfs.so
%if_with doc
%_man8dir/vfs_glusterfs.8*
%endif
%endif

%if_with snapper
%files vfs-snapper
%_samba_mod_libdir/vfs/snapper.so
%if_with doc
%_man8dir/vfs_snapper.8*
%endif
%endif

%if_with dc
%files dc-libs
%_samba_mod_libdir/bind9/dlz_bind9_10.so
%_samba_mod_libdir/bind9/dlz_bind9_11.so
%_samba_mod_libdir/bind9/dlz_bind9_12.so
%_samba_mod_libdir/bind9/dlz_bind9_14.so
%_samba_mod_libdir/bind9/dlz_bind9_16.so
%_samba_mod_libdir/bind9/dlz_bind9_18.so
%if_without mitkrb5
%_samba_mod_libdir/libheimntlm-samba4.so.1
%_samba_mod_libdir/libheimntlm-samba4.so.1.0.1
%_samba_mod_libdir/libkdc-samba4.so.2
%_samba_mod_libdir/libkdc-samba4.so.2.0.0
%endif #!mitkrb5
%_samba_mod_libdir/libad-claims-samba4.so
%_samba_mod_libdir/libauth4-samba4.so
%_samba_mod_libdir/libauthn-policy-util-samba4.so
%_samba_mod_libdir/libdb-glue-samba4.so
%_samba_mod_libdir/libdnsserver-common-samba4.so
%_samba_mod_libdir/libdsdb-module-samba4.so
%_samba_mod_libdir/libdsdb-garbage-collect-tombstones-samba4.so
%_samba_mod_libdir/libpac-samba4.so
%_samba_mod_libdir/libscavenge-dns-records-samba4.so
%if_with ldb_modules
%if_with separate_heimdal_server
%_samba_mod_libdir/ldb.mit
%exclude %_samba_mod_libdir/ldb.mit/ldbsamba_extensions.so
%exclude %_samba_mod_libdir/ldb.mit/ildap.so
%else
%_samba_mod_libdir/ldb
%exclude %_samba_mod_libdir/ldb/ldbsamba_extensions.so
%exclude %_samba_mod_libdir/ldb/ildap.so
%endif
%else
%if_with separate_heimdal_server
%_altdir/samba-mit-dc-modules
%dir %_samba_mod_libdir/ldb.mit
%_samba_mod_libdir/ldb.mit
%else
%dir %_samba_mod_libdir/ldb
%_samba_mod_libdir/ldb
%endif
%endif
%dir %_samba_mod_libdir/gensec
%_samba_mod_libdir/gensec
%if_without mitkrb5
%_samba_mod_libdir/libHDB-SAMBA4-samba4.so
%_samba_mod_libdir/libasn1-samba4.so.*
%_samba_mod_libdir/libcom_err-samba4.so.*
%_samba_mod_libdir/libgssapi-samba4.so.*
%_samba_mod_libdir/libhcrypto-samba4.so.*
%_samba_mod_libdir/libhdb-samba4.so.*
%_samba_mod_libdir/libheimbase-samba4.so.*
%_samba_mod_libdir/libhx509-samba4.so.*
%_samba_mod_libdir/libkrb5-samba4.so.*
%_samba_mod_libdir/libroken-samba4.so.*
%_samba_mod_libdir/libwind-samba4.so.*
%else
%_samba_libdir/krb5/plugins/kdb/samba.so
%endif #!mitkrb5
%_samba_mod_libdir/libprocess-model-samba4.so
%_samba_mod_libdir/libservice-samba4.so
%_samba_mod_libdir/process_model
%_samba_mod_libdir/service
%_samba_libdir/libdcerpc-server.so.*
%if_with ntvfs
%_samba_mod_libdir/libntvfs-samba4.so
%endif
%else
%doc README.dc-libs
%_samba_mod_libdir/libdnsserver-common-samba4.so
%endif

%if_with ldb_modules
%files -n libldb-modules-ldap
%if_with separate_heimdal_server
%_altdir/samba-mit-dc-modules
%dir %_samba_mod_libdir/ldb.mit
%_samba_mod_libdir/ldb.mit/ldbsamba_extensions.so
%_samba_mod_libdir/ldb.mit/ildap.so
%else
%dir %_samba_mod_libdir/ldb
%_samba_mod_libdir/ldb/ldbsamba_extensions.so
%_samba_mod_libdir/ldb/ildap.so
%endif
%endif

%if_with libsmbclient
%files -n libsmbclient
%_samba_libdir/libsmbclient.so.%{libsmbclient_so_version}*

%files -n libsmbclient-devel
%dir %_includedir/samba-4.0
%_includedir/samba-4.0/libsmbclient.h
%_samba_libdir/libsmbclient.so
%_pkgconfigdir/smbclient.pc
%if_with doc
%_man7dir/libsmbclient.7*
%endif #doc
%endif

%if_with libwbclient
%files -n libwbclient
%_libdir/libwbclient.so.%{libwbclient_so_version}*
%_samba_mod_libdir/libreplace-samba4.so

%files -n libwbclient-devel
%dir %_includedir/samba-4.0
%_includedir/samba-4.0/wbclient.h
%_samba_libdir/libwbclient.so
%_pkgconfigdir/wbclient.pc
%endif

%if_with libnetapi
%files -n libnetapi
%_samba_libdir/libnetapi.so.%{libnetapi_so_version}*

%files -n libnetapi-devel
%_samba_libdir/libnetapi.so
%dir %_includedir/samba-4.0
%_includedir/samba-4.0/netapi.h
%_pkgconfigdir/netapi.pc
%endif

%files pidl
%attr(755,root,root) %_bindir/pidl
%if_with doc
%_man1dir/pidl.1.*
%endif
%perl_vendor_privlib/*

%files -n python3-module-%name
%python3_sitelibdir/samba/
%_libdir/libsamba*.cpython-*.so.*
%_samba_mod_libdir/libsamba*.cpython-*.so

%files -n python3-module-%name-devel
%_pkgconfigdir/samba*.cpython-*.pc
%_libdir/libsamba*.cpython-*.so

%if_with doc
%files doc
%doc %_defaultdocdir/%rname/htmldocs
%endif

%files test
%_bindir/gentest
%_bindir/locktest
%_bindir/masktest
%_bindir/ndrdump
%_bindir/smbtorture
%_bindir/traffic_learner
%_bindir/traffic_replay
#%_samba_libdir/libtorture.so.*
%if_with dc
%_samba_mod_libdir/libdlz-bind9-for-torture-samba4.so
%else
%_samba_mod_libdir/libdsdb-module-samba4.so
%endif
%if_with doc
%_man1dir/gentest.1*
%_man1dir/locktest.1*
%_man1dir/masktest.1*
%_man1dir/ndrdump.1*
%_man1dir/smbtorture.1*
%_man7dir/traffic_learner.7*
%_man7dir/traffic_replay.7*
%endif

%if_with testsuite
# files to ignore in testsuite mode
%_samba_mod_libdir/libnss-wrapper-samba4.so
%_samba_mod_libdir/libsocket-wrapper-samba4.so
%_samba_mod_libdir/libuid-wrapper-samba4.so
%endif

%files usershares
%config(noreplace) %_sysconfdir/samba/usershares.conf
%config(noreplace) %_sysconfdir/role.d/samba-usershares.role
%attr(1770,root,usershares) %dir /var/lib/samba/usershares
%_controldir/smb-conf-usershares
%_controldir/role-usershares
%_controldir/role-sambashare
%_controldir/smb-conf-usershare-allow-list
%_controldir/smb-conf-usershare-deny-list
%_controldir/smb-conf-usershare-owner-only
%_controldir/smb-conf-usershare-allow-guests

%if_with winbind
%files winbind-common
%attr(750,root,wbpriv) %dir /var/lib/samba/winbindd_privileged
%dir %_samba_piddir/winbindd
%if_with doc
%_man8dir/winbindd.8*
%_man8dir/idmap_*.8*
%endif

%files winbind
%_unitdir/winbind.service
%attr(755,root,root) %_initrddir/winbind
%_sysconfdir/NetworkManager/dispatcher.d/30-winbind
%_samba_mod_libdir/idmap
%_samba_mod_libdir/nss_info
%_samba_mod_libdir/libnss-info-samba4.so
%_samba_mod_libdir/libidmap-samba4.so
%if_with separate_heimdal_server
%_altdir/samba-mit-winbind
%_samba_mod_libdir/sbin/winbindd
%_samba_mod_libdir/bin/wbinfo
%_samba_mod_libdir/bin/ntlm_auth
%else
%_bindir/ntlm_auth
%_bindir/wbinfo
%_sbindir/winbindd
%endif
%if_with doc
%_man1dir/ntlm_auth.1.*
%_man1dir/wbinfo.1*
%endif

%files winbind-clients -f pam_winbind.lang
%_samba_libdir/libnss_winbind.so*
%_samba_libdir/libnss_wins.so*
/%_lib/security/pam_winbind.so
%config(noreplace) %_sysconfdir/security/pam_winbind.conf
%if_with doc
%_man5dir/pam_winbind.conf.5*
%_man8dir/pam_winbind.8*
%endif

%files winbind-krb5-locator
%ghost %_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so
%_altdir/samba-mit-winbind-krb5-locator
%_samba_mod_libdir/krb5/winbind_krb5_locator.so
%_samba_mod_libdir/krb5/async_dns_krb5_locator.so
%if_with doc
%_man8dir/winbind_krb5_locator.8*
%endif #doc

%if_with mitkrb5
%files winbind-krb5-localauth
%_libdir/krb5/plugins/libkrb5/winbind_krb5_localauth.so
%if_with doc
%_man8dir/winbind_krb5_localauth.8*
%endif #doc
%endif #mitkrb5
%endif #winbind

%if_with clustering_support
%files ctdb
#doc ctdb/README
%dir %_sysconfdir/ctdb
%config(noreplace) %_sysconfdir/ctdb/nodes
%config(noreplace) %_sysconfdir/ctdb/notify.sh
%config(noreplace) %_sysconfdir/ctdb/debug-hung-script.sh
%config(noreplace) %_sysconfdir/ctdb/ctdb-crash-cleanup.sh
%config(noreplace) %_sysconfdir/ctdb/functions
%config(noreplace) %_sysconfdir/ctdb/debug_locks.sh
%_sysconfdir/ctdb/statd-callout
%dir /var/lib/ctdb
%_unitdir/ctdb.service
%_initdir/ctdb
%_tmpfilesdir/ctdb.conf

%_sysconfdir/ctdb/nfs-checks.d
%_sysconfdir/ctdb/nfs-linux-kernel-callout
%_sysconfdir/sudoers.d/ctdb
%dir %_sysconfdir/ctdb/events
%dir %_sysconfdir/ctdb/events/notification
%dir %_sysconfdir/ctdb/events/legacy
%_sysconfdir/ctdb/events/notification/README
%dir %_datadir/ctdb/events/legacy
%_datadir/ctdb/events/legacy/*.script
%_sbindir/ctdbd
%_bindir/ctdb
%_bindir/ctdb_diagnostics
%_bindir/ltdbtool
%_bindir/onnode
%_bindir/ping_pong
%_libexecdir/ctdb/ctdb-config
%_libexecdir/ctdb/ctdb-event
%_libexecdir/ctdb/ctdb-eventd
%_libexecdir/ctdb/ctdb-path
%_libexecdir/ctdb/ctdb_killtcp
%_libexecdir/ctdb/ctdb_lock_helper
%_libexecdir/ctdb/ctdb_lvs
%_libexecdir/ctdb/ctdb_mutex_fcntl_helper
%_libexecdir/ctdb/ctdb_natgw
%_libexecdir/ctdb/ctdb_recovery_helper
%_libexecdir/ctdb/ctdb_takeover_helper
%_libexecdir/ctdb/tdb_mutex_check
%_libexecdir/ctdb/smnotify

%if_with doc
%_man1dir/ctdb.1*
%_man1dir/ctdbd.1*
%_man1dir/onnode.1*
%_man1dir/ltdbtool.1*
%_man1dir/ping_pong.1*
%_man1dir/ctdb_diagnostics.1*
%_man5dir/ctdb.conf.5*
%_man5dir/ctdb-script.options.5*
%_man5dir/ctdb.sysconfig.5*
%_man7dir/ctdb.7*
%_man7dir/ctdb-tunables.7*
%_man7dir/ctdb-statistics.7*
%endif

%if_with testsuite
%files ctdb-tests
%doc ctdb/tests/README
%_libexecdir/ctdb/tests
%_bindir/ctdb_local_daemons
%_bindir/ctdb_run_tests
%_bindir/ctdb_run_cluster_tests
%_datadir/ctdb/tests
%endif #testsuite

%if_enabled pcp_pmda
%files ctdb-pcp-pmda
%dir %_localstatedir/lib/pcp/pmdas/ctdb
%_localstatedir/lib/pcp/pmdas/ctdb/Install
%_localstatedir/lib/pcp/pmdas/ctdb/README
%_localstatedir/lib/pcp/pmdas/ctdb/Remove
%_localstatedir/lib/pcp/pmdas/ctdb/domain.h
%_localstatedir/lib/pcp/pmdas/ctdb/help
%_localstatedir/lib/pcp/pmdas/ctdb/pmdactdb
%_localstatedir/lib/pcp/pmdas/ctdb/pmns
%endif

%if_enabled etcd_mutex
%files ctdb-etcd-mutex
%_libexecdir/ctdb/ctdb_etcd_lock
%_man7dir/ctdb-etcd.7*
%endif

%if_enabled ceph_mutex
%files ctdb-ceph-mutex
%_libexecdir/ctdb/ctdb_mutex_ceph_rados_helper
%_man7dir/ctdb_mutex_ceph_rados_helper.7*
%endif
%endif #clustering_support

%files -n task-samba-dc

%files util-private-headers
%dir %_includedir/samba-4.0/private
%_includedir/samba-4.0/private

%changelog
