# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

#set_verify_elf_method relaxed

Name: screengrab
Version: 2.7.0
Release: alt1

Summary: ScreenGrab is a tool for geting screenshots
License: GPL-2.0-only
Group: Graphics

Url: https://github.com/lxqt/screengrab
Source: %name-%version.tar
Patch0: screengrab-link.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: /proc
BuildRequires: cmake
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Help)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(Qt5Xdg)
BuildRequires: kf5-kwindowsystem-devel
BuildRequires: libqtxdg-devel
# To generate screengrab.desktop
BuildRequires: perl-YAML-LibYAML-API

%description
ScreenGrab -- program getting screenshots working in Linux and Windows.
The program uses Qt5 and is independent from any desktop environment.
Main features:
    * grab screenshot of desktop
    * working on Window and Linux operating systems
    * save screenshots in PNG and JPEG format
    * grab screenshot with delay (1 - 90 sec)
    * hide its window
    * minimize to system tray and work from at (tray menu)

%prep
%setup
%autopatch -p1

find -type f -print0 | xargs -r0 chmod 644 --

# fix docs directories
sed -i 's|${CMAKE_INSTALL_FULL_DOCDIR}|${CMAKE_INSTALL_FULL_DOCDIR}-%version|g' CMakeLists.txt

%ifarch %e2k
%add_optflags -std=c++11
%endif

%build
%cmake
%cmake_build

%install
%cmake_install

%files
%_bindir/%name
%_desktopdir/%name.desktop
%_docdir/%name-%version/
%_datadir/%name/
%_iconsdir/hicolor/scalable/apps/screengrab.svg
%_datadir/metainfo/screengrab.metainfo.xml

%changelog
