%def_disable snapshot
%def_enable updatedb
%def_enable check

%define ver_major 2
%define ver_minor 2

Name: shared-mime-info
Version: %ver_major.%ver_minor
Release: alt1

Summary: Shared MIME-Info Specification
Group: System/Libraries
License: GPL-2.0
Url: http://www.freedesktop.org/wiki/Software/%name

%if_disabled snapshot
#Source: https://github.com/freedesktop/xdg-%name/archive/Release-%ver_major-%ver_minor/%name-%version.tar.gz
Source: https://gitlab.freedesktop.org/xdg/shared-mime-info/-/archive/%version/%name-%version.tar.gz
%else
Vcs: https://gitlab.freedesktop.org/xdg/shared-mime-info.git
Source: %name-%version.tar
%endif
Source1: %name.filetrigger
# https://gitlab.freedesktop.org/xdg/xdgmime.git
Source2: xdgmime-92f6a09.tar

Patch: %name-2.0-alt-cachedir-param.patch
Patch2: %name-2.0-alt-q_option.patch

%define glib_ver 2.6.0
%define libxml2_ver 2.4.0

BuildRequires(pre): rpm-macros-meson rpm-build-xdg
BuildRequires: meson libgio-devel >= %glib_ver libxml2-devel >= %libxml2_ver
BuildRequires: xmllint xmlto

%description
This is the freedesktop.org shared MIME info database.

Many programs and desktops use the MIME system to represent the types of
files. Frequently, it is necessary to work out the correct MIME type for
a file. This is generally done by examining the file's name or contents,
and looking up the correct MIME type in a database.

For interoperability, it is useful for different programs to use the
same database so that different programs agree on the type of a file,
and new rules for determining the type apply to all programs.

This specification attempts to unify the type-guessing systems currently
in use by GNOME, KDE and ROX. Only the name-to-type and contents-to-type
mappings are covered by this spec; other MIME type information, such as
the default handler for a particular type, or the icon to use to display
it in a file manager, are not covered since these are a matter of style.

In addition, freedesktop.org provides a shared database in this format
to avoid inconsistencies between desktops. This database has been
created by converting the existing KDE and GNOME databases to the new
format and merging them together.

%prep
%setup
cp %SOURCE1 .
tar -xf %SOURCE2 --strip-components=1 -C xdgmime

%patch -p1 -b .cachedir
%patch2 -p1 -b .quiet

rm -f freedesktop.org.xml

%build
pushd xdgmime
CC=gcc %make_build
popd
%meson \
%{?_enable_updatedb:-Dupdate-mimedb=true}
%nil
%meson_build

%install
%meson_install

cat <<__SH__ >%name.sh
export XDG_DATA_DIRS="\${XDG_DATA_DIRS-%_datadir}"
__SH__

cat <<__CSH__ >%name.csh
setenv XDG_DATA_DIRS "%_datadir"
__CSH__

install -pD -m755 %name.sh %buildroot%_sysconfdir/profile.d/%name.sh
install -pD -m755 %name.csh %buildroot%_sysconfdir/profile.d/%name.csh

# posttrans filetrigger
install -pD -m 755 shared-mime-info.filetrigger %buildroot%_rpmlibdir/mime-database.filetrigger

# do empty db files and create file list
find %buildroot%_xdgmimedir -type f |fgrep -v "/packages/" > db.files
cat db.files| while read f; do echo -n > $f; done
find %buildroot%_xdgmimedir -mindepth 1 -type d |sed -e "s,^,%%dir ," >> db.files
subst 's,%buildroot,,' db.files

%triggerpostun -- %name < 0.13-alt2
rm -rf %_xdgmimedir/{application,audio,globs,image,inode,magic,message,model,\
multipart,text,video,XMLnamespaces}

%check
%meson_test

%files -f db.files
%_bindir/update-mime-database
%_xdgmimedir/packages/freedesktop.org.xml
%_man1dir/update-mime-database.1.*
%_datadir/pkgconfig/%name.pc
%_datadir/gettext/its/%name.*

%exclude  %config(noreplace) %_sysconfdir/profile.d/*

# filetrigger
%_rpmlibdir/mime-database.filetrigger
%doc README* NEWS data/shared-mime-info-spec.xml

%exclude %_datadir/locale

%changelog
