%define _unpackaged_files_terminate_build 1

%def_with check

Name: shim
Version: 15.8
Release: alt1

Summary: First-stage UEFI bootloader
License: BSD
Group: System/Kernel and hardware

Url: https://github.com/rhboot/shim
Source: %name-%version.tar
Source1: altlinux-ca.cer
Source2: %name-%version-gnu-efi.tar

Patch0: shim-15.8-alt-Bump-grub-SBAT-revocation-to-4.patch

BuildRequires(pre): rpm-macros-uefi
BuildRequires: pesign >= 0.106
BuildRequires: libelf-devel
BuildRequires: dos2unix

%if_with check
BuildRequires: xxd
BuildRequires: libefivar-devel
%endif

# Shim is only required on platforms implementing the UEFI secure boot
# protocol. The only one of those we currently wish to support is 64-bit x86.
# Adding further platforms will require adding appropriate relocation code.
ExclusiveArch: x86_64

# Figure out the right file path to use
%global efidir altlinux
# SBAT generation number for ALT (refer to SBAT.md)
%global alt_gen_number 1

%description
Initial UEFI bootloader that handles chaining to a trusted
full bootloader under secure boot environments.

%package -n %name-unsigned
Summary: First-stage UEFI bootloader (unsigned data)
Group: System/Kernel and hardware

%description -n %name-unsigned
Initial UEFI bootloader that handles chaining to a trusted
full bootloader under secure boot environments.
Includes both ia32 and x64 EFI binaries.

%prep
%setup -a 2
%patch0 -p1

echo "shim.altlinux,%alt_gen_number,ALT Linux,shim,%version-%release,http://git.altlinux.org/gears/s/shim.git" > data/sbat.altlinux.csv

%build
MAKEFLAGS="DISABLE_REMOVABLE_LOAD_OPTIONS=1"
if [ -f "%SOURCE1" ]; then
	MAKEFLAGS="VENDOR_CERT_FILE=%SOURCE1 $MAKEFLAGS"
fi

mkdir build-ia32 build-x64
pushd build-ia32
  %make_build ${MAKEFLAGS} TOPDIR=.. ARCH=ia32 -f ../Makefile
popd
pushd build-x64
  %make_build ${MAKEFLAGS} TOPDIR=.. -f ../Makefile
popd

%install
#be aware of installation target options - refer to BUILDING
pushd build-ia32
make TOPDIR=.. ARCH=ia32 \
     DESTDIR=%buildroot EFIDIR=%efidir \
     -f ../Makefile install-as-data
pesign -h -P -i shimia32.efi -h > shimia32.hash
install -m 0644 shimia32.hash %buildroot%_datadir/shim/%version/ia32/shimia32.hash
install -m 0644 BOOTIA32.CSV %buildroot%_datadir/shim/%version/ia32/BOOTIA32.CSV
popd
pushd build-x64
make TOPDIR=.. DESTDIR=%buildroot EFIDIR=%efidir \
     -f ../Makefile install-as-data
pesign -h -P -i shimx64.efi -h > shimx64.hash
install -m 0644 shimx64.hash %buildroot%_datadir/shim/%version/%_efi_arch/shimx64.hash
install -m 0644 BOOTX64.CSV %buildroot%_datadir/shim/%version/%_efi_arch/BOOTX64.CSV
popd

%check
%make_build test

%files -n %name-unsigned
%doc README.md README.fallback README.tpm COPYRIGHT
%dir %_datadir/shim
%dir %_datadir/shim/%version
%dir %_datadir/shim/%version/ia32
%dir %_datadir/shim/%version/%_efi_arch
%_datadir/shim/%version/%_efi_arch/*
%_datadir/shim/%version/ia32/*

%changelog
