Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: unzip
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-1.8-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       simplevalidation
# upstream is pretty bad about version numbering
# this is a guess based on the version of a separate api "release" jar
Version:    1.0
Release:    alt3_0.6.SNAPSHOTjpp8
Summary:    A library for adding user-interface input validation to Swing applications
License:    GPLv2 or CDDL
URL:        http://kenai.com/projects/simplevalidation
# svn export -r331 https://svn.kenai.com/svn/simplevalidation~src/trunk/ simplevalidation-1.0-SNAPSHOT
# tar cJf simplevalidation-1.0-SNAPSHOT-20121212.tar.xz simplevalidation-1.0-SNAPSHOT
Source0:    http://kenai.com/projects/simplevalidation/downloads/download/validation-src.zip
Patch0:     simplevalidation-1.0-disable-doclint.patch

BuildArch:  noarch

BuildRequires:  javapackages-local

BuildRequires:  ant
BuildRequires:  dos2unix

Requires:   jpackage-utils
Requires:   java
Source44: import.info

%description
This is a simple library for quickly adding validation code to Swing
user-interfaces. It handles validating user input when the user changes a
component's value, showing error messages and decorating components to
indicate which component is the source of the problem. It contains a large
number of built-in validators to handle most common situations, such as
validating numbers, email addresses, urls and so forth.

The primary goal is to make it easy to retrofit validation code on existing
UIs without needing to rewrite anything or add more than a few lines of code.

%package javadoc
Group: Development/Java
Summary:    Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}

%prep
%setup -q -c
%patch0 -p0

find . -name '*.class' -delete
find . -name '*.jar' -delete

%pom_xpath_remove "pom:project/pom:profiles" maven

%build

cd ValidationAPI
ant -Dplatforms.JDK_1.5.home=%{_jvmdir}/java jar javadoc

dos2unix dist/javadoc/package-list
dos2unix dist/javadoc/stylesheet.css

%install

mkdir -p %{buildroot}%{_javadir}
cp -a ValidationAPI/dist/ValidationAPI.jar %{buildroot}%{_javadir}/ValidationAPI.jar

mkdir -p %{buildroot}%{_mavenpomdir}
install -pm 644 maven/pom.xml %{buildroot}%{_mavenpomdir}/JPP-ValidationAPI.pom
%add_maven_depmap JPP-ValidationAPI.pom ValidationAPI.jar -a "com.kenai:ValidationAPI"

mkdir -p %{buildroot}%{_javadocdir}/%{name}
cp -a ValidationAPI/dist/javadoc/* %{buildroot}%{_javadocdir}/%{name}

%files -f .mfiles
%doc ValidationAPI/doc/overview.html
%doc ValidationAPI/doc/duckLogo.png
%{_javadir}/ValidationAPI.jar
%{_mavenpomdir}/*

%files javadoc
%{_javadocdir}/%{name}

%changelog
