%def_with bootstrap

Name:           solaar
Version:        1.1.7
Release:        alt1

Group:          System/Configuration/Hardware
Summary:        Device manager for Logitech Unifying Receiver
URL:            https://pwr-solaar.github.io/Solaar/
BuildArch:      noarch
License:        GPL-2.0

Packager:	Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-gir
BuildRequires:  python3-module-pyudev

Requires:  	unifying-receiver-udev

%if_with bootstrap
%add_python3_req_skip gi.repository.GObject gi.repository.Gdk
%endif

# typelib(AyatanaAppIndicator3) is not package in ALT Linux
%add_typelib_req_skiplist typelib(AyatanaAppIndicator3)

Source0: https://github.com/pwr/Solaar/archive/%{version}.tar.gz
Source1: submodules.tar
Patch1: solaar-paths.patch

%description
Solaar is a device manager for Logitech's Unifying Receiver
peripherals. It is able to pair/unpair devices to the receiver, and
for most devices read battery status.

It comes in two flavors, command-line and GUI. Both are able to list
the devices paired to a Unifying Receiver, show detailed info for each
device, and also pair/unpair supported devices with the receiver.

%package doc
Group:          Documentation
Summary:        Documentation for Solaar
Requires:       %name = %version-%release
BuildArch:      noarch

%description doc
This package provides documentation for Solaar, a device manager for
Logitech's Unifying Receiver peripherals.

%prep
%setup -n Solaar-%version
%patch1 -p1
tar xf %SOURCE1

%build
tools/po-compile.sh
%python3_build

%install
%python3_install
%find_lang %name

%files -f %name.lang
%doc COPYRIGHT share/README
%config(noreplace) %_sysconfdir/xdg/autostart/solaar.desktop
%_libexecdir/udev/rules.d/*.rules
%_bindir/solaar
%python3_sitelibdir/*
%_datadir/solaar/
%_desktopdir/solaar.desktop
%_iconsdir/hicolor/scalable/apps/solaar.svg
%_datadir/metainfo/*.metainfo.xml

%files doc
%doc docs

%changelog
