Group: Games/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat rpm-macros-ninja-build
BuildRequires: /usr/bin/clang-format /usr/bin/cppcheck /usr/bin/desktop-file-validate /usr/bin/doxygen /usr/bin/wx-config-3.0 libX11-devel libpcre-devel pkgconfig(glib-2.0) python-devel rpm-build-python zlib-devel
# END SourceDeps(oneline)
# undefined symbol: L_*, LOG_*, parse32 in libFileSystem
# those are from static libUtil, in main binary
%set_verify_elf_method unresolved=relaxed
BuildRequires: boost-devel boost-filesystem-devel boost-signals-devel libpng-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Colorize terminal output. Helps to find problems during build process.
%global optflags %{optflags} -fdiagnostics-color=always

Name:           springlobby
Version:        0.271
Release:        alt1_1
Summary:        Free cross-platform lobby client for the Spring RTS project

# License clarification: http://springlobby.info/issues/show/810
License:        GPLv2
URL:            https://springlobby.springrts.com/
Source0:        https://springlobby.springrts.com/dl/stable/springlobby-%{version}.tar.bz2
ExclusiveArch:  %{ix86} x86_64

BuildRequires:  libalure-devel
BuildRequires:  boost-complete
BuildRequires:  ctest cmake
BuildRequires:  desktop-file-utils
BuildRequires:  dumb-devel
BuildRequires:  gcc-c++ >= 8
BuildRequires:  gettext gettext-tools
BuildRequires:  libappstream-glib
BuildRequires:  libcurl-devel
BuildRequires:  libnotify-devel libnotify-gir-devel
BuildRequires:  libminizip-devel
BuildRequires:  ninja-build python3-module-ninja_syntax
BuildRequires:  libopenal-devel
BuildRequires:  libtorrent-rasterbar-devel
BuildRequires:  libSDL_mixer-devel
BuildRequires:  libSDL_sound-devel
BuildRequires:  libSDL-devel
BuildRequires:  libwxGTK3.0-devel

# https://github.com/springlobby/springlobby/issues/709
BuildRequires:  jsoncpp-devel

Requires:       icon-theme-hicolor
Requires:       libGLU

Requires:     libfluidsynth
Requires:     springrts

# There are other "lobbies" for spring, make a virtual-provides
Provides:       spring-lobby = %{version}-%{release}
Source44: import.info
Patch33: springlobby-0.270-alt-linkage.patch

%description
SpringLobby is a free cross-platform lobby client for the Spring RTS project.


%prep
%setup -q


# Unbunle libs
rm -rf \
    src/downloader/lib/src/lib/minizip
%patch33 -p1


%build
%{fedora_v2_cmake} \
    -B $PWD/%{_vpath_builddir} \
    -G Ninja


%install
%ninja_install -C %{_vpath_builddir}
%find_lang %{name}
rm -rf %{buildroot}%{_docdir}/%{name}/COPYING


%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/*.xml
desktop-file-validate %{buildroot}%{_datadir}/applications/*.desktop


%files -f %{name}.lang
%doc --no-dereference COPYING
%doc ChangeLog
%{_bindir}/%{name}
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/scalable/apps/*.svg
%{_docdir}/%{name}/
%{_metainfodir}/*.xml


%changelog
