%def_disable clang

Name: strawberry
Version: 0.9.3
Release: alt1.1
Summary: Audio player and music collection organizer

# Main program: GPL-3.0-or-later
# src/engine/gstengine and src/engine/xineengine: GPL-2.0-or-later
# 3rdparty/taglib: LGPL-2.1
# 3rdparty/singleapplication and src/widgets/qocoa_mac.h: MIT
# 3rdparty/utf8-cpp: BSL
# src/core/timeconstants.h and ext/libstrawberry-common/core/logging and ext/libstrawberry-common/core/messagehandler: APSL-2.0
License: GPL-2.0-or-later and GPL-3.0-or-later and LGPL-2.1 and APSL-2.0 and MIT and BSL
Group: Sound
Url: https://www.strawberrymusicplayer.org/
Packager: Leontiy Volodin <lvol@altlinux.org>

Source: https://github.com/jonaski/strawberry/archive/%version/%name-%version.tar.gz

BuildRequires(pre): desktop-file-utils rpm-build-ninja
BuildRequires: boost-program_options-devel ccache gettext-tools glib2-devel gst-plugins1.0-devel gstreamer1.0-devel libalsa-devel libcdio-devel libchromaprint-devel libdbus-devel libfftw3-devel libgio-devel libgnutls-devel libgpod-devel libimobiledevice-devel libmtp-devel libplist-devel libprotobuf-devel libpulseaudio-devel libsqlite3-devel libtag-devel libusbmuxd-devel libvlc-devel libxine2-devel qt5-phonon-devel qt5-x11extras-devel
BuildRequires: cmake libappstream-glib qt5-tools-devel protobuf-compiler libusb-devel
%ifnarch s390 s390x
BuildRequires: libgpod-devel
%endif

Requires: gst-plugins-good1.0 vlc-mini

Provides: bundled(SPMediaKeyTap)
Provides: bundled(singleapplication)
Provides: bundled(singlecoreapplication)

%description
Strawberry is a audio player and music collection organizer.
It is a fork of Clementine. The name is inspired by the band Strawbs.

Features:
  * Play and organize music
  * Supports WAV, FLAC, WavPack, DSF, DSDIFF, Ogg Vorbis, Speex, MPC,
    TrueAudio, AIFF, MP4, MP3 and ASF
  * Audio CD playback
  * Native desktop notifications
  * Playlists in multiple formats
  * Advanced output and device options with support for bit perfect playback
    on Linux
  * Edit tags on music files
  * Fetch tags from MusicBrainz
  * Album cover art from Last.fm, Musicbrainz and Discogs
  * Song lyrics from AudD and API Seeds
  * Support for multiple backends
  * Audio analyzer
  * Equalizer
  * Transfer music to iPod, iPhone, MTP or mass-storage USB player
  * Integrated Tidal support
  * Scrobbler with support for Last.fm, Libre.fm and ListenBrainz

%prep
%setup

# Remove most 3rdparty libraries
# Unbundle taglib next release:
# https://github.com/taglib/taglib/issues/837#issuecomment-428389347

mv 3rdparty/singleapplication/LICENSE 3rdparty/singleapplication/LICENSE-singleapplication
mv 3rdparty/SPMediaKeyTap/LICENSE 3rdparty/SPMediaKeyTap/LICENSE-SPMediaKeyTap

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
%else
export CC="gcc"
export CXX="g++"
export AR="ar"
%endif

%cmake \
  -GNinja \
  -DBUILD_WERROR=OFF \
  -DUSE_SYSTEM_TAGLIB=ON

%cmake_build

%install
%cmake_install

%check
desktop-file-validate %buildroot%_desktopdir/org.strawberrymusicplayer.strawberry.desktop
appstream-util validate-relax --nonet %buildroot%_datadir/metainfo/org.strawberrymusicplayer.strawberry.appdata.xml

%files
%doc COPYING 3rdparty/singleapplication/LICENSE-singleapplication 3rdparty/SPMediaKeyTap/LICENSE-SPMediaKeyTap
%doc Changelog
%_bindir/strawberry
%_bindir/strawberry-tagreader
%_datadir/metainfo/org.strawberrymusicplayer.strawberry.appdata.xml
%_desktopdir/org.strawberrymusicplayer.strawberry.desktop
%_iconsdir/hicolor/*/apps/strawberry.*
%_man1dir/strawberry.1.*
%_man1dir/strawberry-tagreader.1.*

%changelog
