# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%ifnarch ppc64le
%set_verify_elf_method strict
%endif

Name: stress-ng
Version: 0.12.12
Release: alt1
Summary: Stress test a computer system in various selectable ways
Group: System/Kernel and hardware
License: GPL-2.0-only
Url: http://kernel.ubuntu.com/~cking/stress-ng/
Vcs: git://kernel.ubuntu.com/cking/stress-ng.git
# Mirror Vcs: https://github.com/ColinIanKing/stress-ng

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-make
BuildRequires: banner
BuildRequires: libaio-devel
BuildRequires: libattr-devel
BuildRequires: libbsd-devel
BuildRequires: libcap-devel
BuildRequires: libgcrypt-devel
BuildRequires: libkeyutils-devel
BuildRequires: libkmod-devel
BuildRequires: liblksctp-devel
BuildRequires: libseccomp-devel
BuildRequires: zlib-devel

%description
stress-ng will stress test a computer system in various selectable
ways. It was designed to exercise various physical subsystems
of a computer as well as the various operating system kernel
interfaces. Stress-ng features:

* 250 stress tests
* 80+ CPU specific stress tests that exercise floating point,
  integer, bit manipulation and control flow
* over 20 virtual memory stress tests
* portable: builds on Linux, etc.

%prep
%setup
%ifarch %e2k
# lcc 1.23 can't do string attribute form (1.24.03 will; mcst#4061)
sed -ri 's,"-O([0123])",\1,' stress-ng.h
%endif

%build
%add_optflags -flto
%make_build_ext --no-print-directory --output-sync=none VERBOSE=1

%install
%makeinstall_std

install -pD kernel-coverage.sh %buildroot%_datadir/stress-ng/kernel-coverage.sh
install -pD syscalls.txt       %buildroot%_datadir/stress-ng/syscalls.txt

%check
# getrandom test does not work in sborotschnitza:
#   getrandom using flags GRND_INSECURE failed, errno=22 (Invalid argument)
sed -i '/STRESSORS/s/getrandom //g' debian/tests/lite-test
# Cache test for a long time hanging ALT beekeeper for a unknown reason.
sed -i '/STRESSORS/s/ cache / /g' debian/tests/lite-test

banner lite-test
SEGFAULT_SIGNALS="segv abrt" LD_PRELOAD=libSegFault.so time timeout -s6 300 \
	make lite-test
banner done

%files
%doc COPYING README
%_bindir/stress-ng
%_datadir/bash-completion/completions/stress-ng
%_datadir/stress-ng
%_mandir/man1/stress-ng.1*

%changelog
