%define _unpackaged_files_terminate_build 1

%def_without doc

Name: sympy
Version: 1.7.1
Release: alt1
Epoch: 1

Summary: A Python library for symbolic mathematics

License: BSD-3-Clause
Group: Sciences/Mathematics
Url: https://sympy.org/

BuildArch: noarch

# https://github.com/sympy/sympy.git
Source: %name-%version.tar
Patch1: %name-%version-alt-build.patch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-py
BuildRequires: python3-module-mpmath
BuildRequires: dvipng ImageMagick-tools graphviz librsvg-utils
%if_with doc
BuildRequires(pre): python3-module-sphinx-devel
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-docutils
BuildRequires: python3-module-Pygments
BuildRequires: python3-module-sphinx-math-dollar
BuildRequires: python3(matplotlib) python3(matplotlib.sphinxext)
BuildRequires: python3-module-sphinx-pickles
%endif

Requires: python3-module-%name = %EVR

%add_python3_req_skip py.__.test.item py.__.test.terminal.terminal

%description
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

%package -n python3-module-%name
Summary: A Python 3 module for symbolic mathematics
Group: Development/Python3

%description -n python3-module-%name
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains python module of SymPy.

%package -n python3-module-%name-examples
Summary: Examples for SymPy
Group: Development/Documentation
Requires: python3-module-%name = %EVR

%description -n python3-module-%name-examples
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains examples for SymPy.

%package -n python3-module-%name-pickles
Summary: Pickles for SymPy
Group: Development/Python
Requires: python3-module-%name = %EVR

%description -n python3-module-%name-pickles
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains pickles for SymPy.

%package -n python3-module-%name-doc
Summary: Documentation for SymPy
Group: Development/Documentation
BuildArch: noarch

%description -n python3-module-%name-doc
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains development documentation for SymPy.

%prep
%setup
%patch1 -p1

for i in $(find ./ -name tests); do
	touch $i/__init__.py
done

sed -i 's|@PYVER@|%_python3_version|g' doc/Makefile
%if_with doc
%prepare_sphinx3 .
%endif

%build
export LC_ALL=en_US.UTF-8
%python3_build

%if_with doc
pushd doc
%make html
popd

rm -fR doctrees
cp -fR doc/_build/doctrees doc/src/
export PYTHONPATH=$PYTHONPATH:$PWD
cp -fR doc/_build/doctrees ./

%generate_pickles3 $PWD $PWD/doc/_build/html %name
%endif

%install
%python3_install

%if_with doc
cp -fR pickle %buildroot%python3_sitelibdir/%name/
%endif

# remove tests files
%python3_prune
# by some reason sympy.testing is wide used in the project modules
#rm -rfv %buildroot%python3_sitelibdir/%name/testing/
rm -rfv %buildroot%python3_sitelibdir/%name/conftest.py
rm -rfv %buildroot%python3_sitelibdir/%name/utilities/{*test.py,_compilation/}
rm -rfv %buildroot%python3_sitelibdir/%name/parsing/autolev/test-examples/

%check
#python3 setup.py test -v
#python3 bin/test -v
%if_with doc
python3 bin/doctest -v ||:
%endif

%files
%doc AUTHORS LICENSE README* CODE_OF_CONDUCT.md
%_bindir/*
%_man1dir/*

%files -n python3-module-%name
%python3_sitelibdir/*
%if_with doc
%exclude %python3_sitelibdir/%name/pickle
%endif

%files -n python3-module-%name-examples
%doc examples/*

%if_with doc
%files -n python3-module-%name-pickles
%python3_sitelibdir/%name/pickle

%files -n python3-module-%name-doc
%doc doc/_build/html/*
%endif

%changelog
