%define teaname img
%define major 1.4

Name: tcl-img
Version: 1.4.13
Release: alt1

Summary: Tcl Image Formats (Img)
License: TCL
Group: Development/Tcl
Url: https://sourceforge.net/projects/tkimg/

Provides: %teaname = %version-%release
Obsoletes: %teaname
Conflicts: tcl < 8.6.7-alt2

# repacked https://sourceforge.net/projects/tkimg/files/tkimg/1.4/ "tkimg %version" Img-%version-Sources.tar.gz
Source0: tkimg-%version.tar
Source1: tcl-img.watch
Patch1: 0001-ALT-TEA.patch
Patch2: 0002-DEBIAN-libz.patch
Patch3: 0003-DEBIAN-libjpeg.patch
Patch4: 0004-DEBIAN-libpng.patch
Patch6: 0006-DEBIAN-pixmap.patch
Patch7: 0007-DEBIAN-window.patch
Patch8: 0008-ALT-tests-TCLLIBPATH.patch

BuildRequires: rpm-build-tcl >= 0.5-alt1
BuildRequires: libjpeg-devel libpng-devel tk-devel zlib-devel
BuildRequires: libtiff-devel
BuildRequires: tcllib
# tests
BuildRequires: xvfb-run

%description
%name is a Tk enhancement, adding support for many other Image formats:
BMP, XBM, XPM, GIF, PNG, JPEG, postscript and others.

%prep
%setup -q -n tkimg-%version
%autopatch -p2
find . -name config.cache -delete

%build
export TCL_SRC_DIR=%_includedir/tcl
export TK_SRC_DIR=%_includedir/tk
%autoreconf
%configure \
	   --with-tcl=%_libdir \
	   --with-tk=%_libdir \
	   --enable-threads \
	   #
%make_build

xz ChangeLog

%install
%make_install DESTDIR=%buildroot install

%check
log="$(mktemp)"
cleanup_check()
{
	for p in $(jobs -p); do
		kill "$p"
	done

	rm "$log"
	exit "$@"
}

trap 'cleanup_check $?' EXIT

Xvfb :0 &
export DISPLAY=:0

# broken
rm tests/jpeg.test

# tcltest always retuns 0
set -eo pipefail
make test 2>&1 |tee "$log"
! grep -q FAILED "$log" ||exit 1

%files
%doc ANNOUNCE ChangeLog* README doc/*.css doc/*.htm license.terms
%_tcllibdir/Img%version/*.so
%_tcllibdir/Img%version/pkgIndex.tcl
%_mandir/mann/*

%changelog
