%define oname tcltls

Name: tcl-tls
Version: 1.7.22
Release: alt1

Summary: A tcl extension, wich adds SSL ability to any Tcl channel
License: TCL
Group: Development/Tcl
Url: https://core.tcl.tk/tcltls/

# repacked https://core.tcl-lang.org/tcltls/uv/tcltls-%version.tar.gz
Source: %oname-%version.tar
Source1: tcl-tls.watch

# hasher chroot
Patch1: 0001-DEBIAN-hostname-tests.patch
Patch2: 0002-ALT-TEA.patch
Patch3: 0003-ALT-tests-auto_path.patch
Patch4: 0004-ALT-disable-cipher-tests.patch

BuildPreReq:  rpm-build-tcl >= 0.5-alt1
BuildRequires: libssl-devel tcl-devel >= 8.6.7-alt2
Requires: tcl >= 8.6.7-alt2

%description
TLS is a Tcl extension, wich adds SSL ability to any Tcl channel.
Both client and server-side sockets are possible, and this code should work
on any platform as it uses a generic mechanism for layering on SSL and Tcl.

%prep
%setup -q -n %oname-%version
%autopatch -p2

%build
%autoreconf
%configure \
	--disable-rpath \
	--enable-hardening \
	--with-openssl-dir="%prefix" \
	#
make

%install
%makeinstall

%check
make test AUTO_PATH=%buildroot%_tcllibdir/tcltls%version

%files
%doc ChangeLog README.txt license.terms tls.htm
%_tcllibdir/tcltls%version/tcltls.so
%_tcllibdir/tcltls%version/pkgIndex.tcl

%changelog
