%define _unpackaged_files_terminate_build 1

Name: tcpdump
Version: 4.99.4
Release: alt1
Epoch: 1

Summary: A network traffic monitoring tool
License: BSD
Group: Monitoring
Url: http://www.tcpdump.org

# git://git.altlinux.org/gears/t/tcpdump
Source: %name-%version-%release.tar

Requires: /var/resolv, libpcap0.8 >= 2:1.10.0

# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: sharutils}}

BuildRequires: libpcap-devel >= 2:1.9.0, libssl-devel

%description
Tcpdump is a command-line tool for monitoring network traffic.  Tcpdump
can capture and display the packet headers on a particular network
interface or on all interfaces.  Tcpdump can display all of the packet
headers, or just the ones that match particular criteria.

%prep
%setup -n %name-%version-%release

%build
%add_optflags -fno-strict-aliasing
%ifarch %ix86
# Since our baseline for i586 does not support SSE, FP calculations can flap
# uncontrollably, leading to test failures intermittent between builds. We
# mitigate this with a cflag. There generally are other options:
# https://lists.xapian.org/pipermail/xapian-devel/2022-October/003403.html
%add_optflags -ffloat-store
%endif
%autoreconf
%configure --without-smi --with-crypto \
	--with-user=tcpdump --with-chroot=/var/resolv
%make_build

%install
mkdir -p %buildroot%_datadir/%name
%makeinstall_std
install -pm755 *.awk %buildroot%_datadir/%name/

%check
%make_build -k check

%post
/usr/sbin/groupadd -r -f tcpdump
/usr/sbin/useradd -r -g tcpdump -d /dev/null -s /dev/null -N tcpdump >/dev/null 2>&1 ||:

%files
%_bindir/*
%_datadir/%name
%_mandir/man?/*
%doc CHANGES CREDITS LICENSE README.md

%changelog
