%define _libexecdir %_prefix/libexec
%def_disable check

Name: telepathy-gabble
Version: 0.18.4
Release: alt3

Summary: Jabber/XMPP connection manager
License: LGPL-2.1 and MIT
Group: Networking/Instant messaging
Url: http://telepathy.freedesktop.org/

Source: http://telepathy.freedesktop.org/releases/telepathy-gabble/%name-%version.tar.gz
Patch: telepathy-gabble-0.18.4-alt-console_py3.patch
# fc
Patch10: telepathy-gabble-0.18.4-fc-python3.patch

%define telepathy_glib_ver 0.19.9
%define glib_ver 2.44

Requires: ca-certificates
# for %_bindir/telepathy-gabble-xmpp-console
Requires: typelib(Gtk) = 3.0
Requires: typelib(GtkSource) = 3.0

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildPreReq: libtelepathy-glib-devel >= %telepathy_glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildRequires: libdbus-devel libdbus-glib-devel libxml2-devel libnice-devel
BuildRequires: libsoup-devel xsltproc libsqlite3-devel libgnutls-devel libgcrypt-devel gtk-doc
BuildRequires: python3-module-twisted-words python3-module-xmpp
%if_enabled check
BuildRequires: /proc dbus-tools-gui python3-module-dbus python3-module-twisted-web
BuildRequires: python3-module-twisted-core-gui python3-module-service-identity
%endif

%description
Gabble is a Jabber/XMPP connection manager for the Telepathy framework,
currently supporting single user chats, multi user chats and voice/video
calls. Install this package to use Telepathy instant messaging clients
with Jabber/XMPP servers, including Google Talk.

%prep
%setup
%patch -b .py3
%patch10 -p1

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
	--disable-static \
	--with-ca-certificates="%_datadir/ca-certificates/ca-bundle.crt" \
	PYTHON=%__python3
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/telepathy-gabble-xmpp-console
%_libexecdir/telepathy-gabble
%dir %_libdir/telepathy/gabble-0/
%dir %_libdir/telepathy/gabble-0/lib/
%_libdir/telepathy/gabble-0/lib/libgabble-plugins.so
%_libdir/telepathy/gabble-0/lib/libgabble-plugins-%version.so
%_libdir/telepathy/gabble-0/lib/libwocky-telepathy-gabble-%version.so
%_libdir/telepathy/gabble-0/lib/libwocky.so
%dir %_libdir/telepathy/gabble-0/plugins
%_libdir/telepathy/gabble-0/plugins/libgateways.so
%_libdir/telepathy/gabble-0/plugins/libconsole.so
%_datadir/dbus-1/services/org.freedesktop.Telepathy.ConnectionManager.gabble.service
%_datadir/telepathy/managers/gabble.manager
%_man8dir/*
%dir %_datadir/doc/telepathy-gabble
%doc %_datadir/doc/telepathy-gabble/*.html
%doc AUTHORS NEWS README

%exclude %_libdir/telepathy/gabble-0/*/*.la

%changelog
