%define        _unpackaged_files_terminate_build 1

Name:          termit
Version:       3.1
Release:       alt1.2
Summary:       Minimalistic terminal emulator with tabs and encoding support
Url:           https://github.com/nonstop/termit/wiki
Vcs:           https://github.com/nonstop/termit.git
License:       GPLv3
Group:         Terminals
Packager:      Maxim Ivanov <redbaron@altlinux.org>

Source0:       %name-%version.tar
Source1:       %name-init.lua
Patch:         ru.po.patch
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: desktop-file-utils
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libgtk+3-devel
BuildRequires: libvte3-devel
BuildRequires: libtinfo-devel
BuildRequires: libpixman-devel
BuildRequires: libXau-devel
BuildRequires: liblua5.3-devel

Requires(pre): alternatives >= 0:0.2.0-alt0.12
Requires:      fonts-ttf-paratype-pt-mono

%description
Simple terminal emulator based on vte library.

Features:
 * multiple tabs
 * switching encodings
 * sessions
 * configurable keybindings
 * embedded Lua
 * xterm-like dynamic window title

%prep
%setup
%patch

%build
cmake -DCMAKE_INSTALL_PREFIX=%_prefix .
%make_build

%install
%make_install DESTDIR=%buildroot install
%find_lang %name

mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt %_bindir/termit 100
EOF

install -m644 -D %SOURCE1 %buildroot%_sysconfdir/xdg/termit/rc.lua
sed -ie 's!@docdir@!%_docdir!g' %buildroot%_sysconfdir/xdg/termit/rc.lua
sed -ie 's!@name@!%name!g' %buildroot%_sysconfdir/xdg/termit/rc.lua
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Utility \
	--add-category=System \
	%buildroot%_desktopdir/termit.desktop

%files -f %name.lang
%_bindir/*
%_altdir/%name
%_desktopdir/*.desktop
%_docdir/%name
%_man1dir/*
%_sysconfdir/xdg/*
%_metainfodir/%name.metainfo.xml

%changelog
