Name: tvheadend
Version: 4.2.8
Release: alt3

Summary: Tvheadend TV streaming server
License: GPLv3
Group: System/Servers
Url: https://tvheadend.org/

Requires(post): pwgen

Source: %name-%version-%release.tar

BuildRequires: cmake gcc-c++ libdbus-devel
BuildRequires: libssl-devel libsystemd-devel liburiparser-devel zlib-devel
BuildRequires: libavfilter-devel libavresample-devel libswresample-devel
BuildRequires: libswscale-devel libavformat-devel libavcodec-devel libavutil-devel
BuildRequires: python2.7(encodings)

%description
Tvheadend is a combined DVB receiver, Digital Video Recorder and
Live TV streaming server for Linux, configured and administered
through a modern web interface.

%prep
%setup

%build
export TVHEADEND_FILE_CACHE=${PWD}/.gear
CFLAGS="%optflags -fcommon -Wno-format-truncation" PYTHON=%__python \
sh configure --bindir=%_sbindir --libdir=%_libdir \
	     --mandir=%_mandir --datadir=%_datadir \
	     --enable-libav --disable-ffmpeg_static
make

%install
%make_install prefix=%_prefix DESTDIR=%buildroot install
install -pm0755 -D tvheadend.init %buildroot%_initdir/tvheadend
install -pm0644 -D tvheadend.sysconfig %buildroot%_sysconfdir/sysconfig/tvheadend
install -pm0644 -D tvheadend.service %buildroot%_unitdir/tvheadend.service

mkdir -p %buildroot%_sysconfdir/tvheadend %buildroot%_localstatedir/tvheadend
touch %buildroot%_sysconfdir/tvheadend/superuser

%pre
%_sbindir/groupadd -r -f _hts &> /dev/null
%_sbindir/useradd -r -g _hts -G radio,video -d %_localstatedir/tvheadend \
	-s /dev/null -c 'Tvheadend pseudouser' -n _hts &> /dev/null ||:

%post
f=%_sysconfdir/tvheadend/superuser
[ -s $f ] || printf '{ "username": "tvheadend", "password": "%%s" }' $(pwgen 12 1) > $f
%post_service tvheadend

%preun
%preun_service tvheadend

%files
%doc README.md QUICKSTART

%_initdir/tvheadend
%_sysconfdir/sysconfig/tvheadend
%_unitdir/tvheadend.service

%dir %attr(0770,root,_hts) %_sysconfdir/tvheadend
%config(noreplace) %attr(0600,_hts,_hts) %_sysconfdir/tvheadend/superuser

%_sbindir/tvheadend
%_datadir/tvheadend
%_man1dir/tvheadend.1*

%dir %attr(0770,root,_hts) %_localstatedir/tvheadend

%changelog
