%define _libexecdir %_prefix/libexec/upower
%def_enable gtk_doc
%ifarch %ix86
%def_disable check
%else
%def_disable check
%endif

Name: upower
Version: 0.99.20
Release: alt1

Summary: Power Management Service
License: GPLv2+
Group: System/Libraries
URL: http://cgit.freedesktop.org/upower/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Provides: DeviceKit-power = 016
Obsoletes: DeviceKit-power < 016
Requires: lib%name = %version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch

%define glib_ver 2.34
%define dbus_ver 1.9.18
%define gudev_ver 235
%define imobiledevice_ver 1.3
%define plist_ver 2.2.0
%define dbusmock_ver 0.23.1

Requires: dbus >= %dbus_ver

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-systemd
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: gtk-doc libusb-devel libgudev-devel >= %gudev_ver libdbus-devel >= %dbus_ver
BuildRequires: libpolkit-devel libudev-devel gobject-introspection-devel
BuildRequires: libimobiledevice-devel > %imobiledevice_ver pkgconfig(libplist-2.0) pkgconfig(systemd)
%{?_enable_check:BuildRequires: /proc /dev/pts python3 python3-module-dbusmock >= %dbusmock_ver
BuildRequires: python3-module-packaging libumockdev-gir python3-module-dbus}

%description
UPower provides a daemon, API and command line tools for
managing power devices attached to the system.

%package -n lib%name
Summary: %name libraries
Group: System/Libraries
Provides: libdevkit-power = 016
Obsoletes: libdevkit-power < 016

%description -n lib%name
Libraries for %name

%package -n lib%name-devel
Summary: Development libraries and headers for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: libdevkit-power-devel = 016
Obsoletes: libdevkit-power-devel < 016

%description -n lib%name-devel
Headers, libraries and API docs for %name

%package -n lib%name-gir
Summary: GObject introspection data for the UPower library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: libdevkit-power-gir = 016
Obsoletes: libdevkit-power-gir < 016

%description -n lib%name-gir
GObject introspection data for the UPower library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the UPower library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release lib%name-devel = %version-%release
Provides: libdevkit-power-gir-devel = 016
Obsoletes: libdevkit-power-gir-devel < 016

%description -n lib%name-gir-devel
GObject introspection devel data for the UPower library

%prep
%setup
%patch -p1

%build
%meson \
	%{?_disable_gtk_doc:-Dgtk-doc=false} \
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%doc AUTHORS NEWS README
%dir %_sysconfdir/UPower
%_sysconfdir/UPower/*.conf
%_unitdir/*
%_udevhwdbdir/95-upower-hid.hwdb
%_udevrulesdir/*.rules
%_bindir/*
%_libexecdir/*
%_datadir/dbus-1/system.d/*.conf
%_datadir/dbus-1/system-services/*.service
%_mandir/man?/*
%dir %_var/lib/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/dbus-1/interfaces/*.xml
%{?_enable_gtk_doc:%_datadir/gtk-doc/html/*}

%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir

%changelog
