%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Name: uw-imap
Version: 2007f
Release: alt1

Summary: Server daemons for IMAP and POP network mail protocols
License: Apache-2.0
Group: System/Servers
Url: http://www.washington.edu/imap/

###########################################
# Relations with other POP3/IMAP server pkgs (like courier-imap)

# Provide the abstract service names (which are virtual pkg names),
# specify their origin (our pkg name as the epoch + version-release):
Provides: IMAPD = %name:%version-%release
Provides: POP3D = %name:%version-%release

# Conflict with all other real pkgs which provide the same services
# (they should specify the origin the same way, so the epoch-version-release
# of the virtual pkgs POP3D & IMAPD will always differ from that of ours if
# they are provided by a different real pkg):
Conflicts: IMAPD < %name:%version-%release
Conflicts: IMAPD > %name:%version-%release
Conflicts: POP3D < %name:%version-%release
Conflicts: POP3D > %name:%version-%release

Conflicts: courier-imap
Conflicts: cyrus-imapd

# End of the statements to describe relations with other POP3/IMAP server pkgs
########################################

# Renaming the pkg between 2000c-ipl3mdk and 2001a-alt1
Obsoletes: imap < 1:2001a-alt1

# Otherwise we get too many unimportant warnings
%define optflags_warnings -Wall -Wno-parentheses

%define WithSSL 1
%if_without ssl
%define WithSSL 0
%endif

%define WithMaildir 0
%if_with maildir
%define WithMaildir 1
%endif

# Fallback values if openssl-config is not available:
%define _ssldir %_localstatedir/ssl
%define _pemdir %_ssldir/certs

%if %WithSSL

# for openssl-config:
BuildPreReq: libssl-devel
%define _ssldir %(openssl-config --openssldir)
%define _pemdir %_ssldir/certs

# the location of certificates is hardcoded into the binaries (hence Requires),
# and we require the location exists on installation (hence PreReq):
Requires: /var/lib/ssl
PreReq(post): /var/lib/ssl

%endif #WithSSL

Requires: pam >= 0.72-ipl11mdk

Packager: Denis Smirnov <mithraen@altlinux.ru>

Source: ftp://ftp.cac.washington.edu/mail/imap-%version.tar.bz2
Source1: imap.pamd
Source2: uw-imap.xinetd
Source3: uw-pop3.xinetd
Source4: uw-pop2.xinetd
Source5: uw-imaps.xinetd
Source6: uw-pop3s.xinetd
Source12: uw-simap.xinetd
Source13: uw-spop3.xinetd
Source8: imap-c-client-maildir.tar.bz2
Source9: uw-imap-2001a-README.IMAPS.ALT

Patch1: uw-imap-2007f-alt1-ALT-custom.patch
Patch2: uw-imap-2001a-debian-portability.patch
Patch5: imap-2007e-overflow.patch
Patch10: imap-2007e-authmd5.patch
Patch13: imap-2007e-poll.patch
# The maildir support (turned on by %WithMaildir)
# is supplied by three source pieces:
# the tarball (Source8) with the module and README,
# a general patch that embeds the maildir module into the build
# process, and a patch special for Pine client (not the imap server).
# The last piece is only included in pine.src.rpm
Patch20:uw-imap-2001a-maildir-embed.patch
# for glibc 2.2.2
Patch22: imap-maildir-glibc-time.patch
Patch21: 1006_openssl1.1_autoverify.patch

# Automatically added by buildreq on Wed Dec 05 2001
BuildRequires: libpam-devel

%if %WithSSL
BuildRequires: libssl-devel
%endif

%package -n lib%name
Summary: Shared library for IMAP applications
Group: System/Libraries

%package devel
Summary: Static library and headers for developing IMAP applications
Group: Development/C

##############################
# Keep in sync with uw-imap main pkg version
# (no Requires: is required here)
Conflicts: %name < %version-%release
Conflicts: %name > %version-%release
# End of statements to keep in sync.
##############################

######################################
# Compatibility with future: we are going to rename (and probably split)
# the ...-devel subpkg to libc-client-devel & libc-client-devel-static
# (see No. 0001557 at bugs.altlinux.ru; we do not rename now because of
# the pre-Master 2.2 freeze)
Provides: libc-client-devel = %version-%release
# End of the statements for Compatibility with future
#########################################

%description
The %name package provides server daemons for both the IMAP (Internet
Message Access Protocol) and POP (Post Office Protocol) mail access
protocols.  The POP protocol uses a "post office" machine to collect mail
for users and allows users to download their mail to their local machine
for reading. The IMAP protocol provides the functionality of POP, but
allows a user to read mail on a remote machine without downloading it to
their local machine.

Install the %name package if you need a server to support the IMAP or the
POP mail access protocols.

These programs were developed at UW (University of Washington).

%description -n lib%name
The lib%name package contains the shared library for running programs
will use the UW IMAP (University of Washington's Internet Message Access Protocol) library.

%description devel
The %name-devel package contains the header files and static libraries for
developing programs which will use the UW IMAP library
(University of Washington's Internet Message Access Protocol library).

%prep
echo Using release number %release
%setup -q -n imap-%version
ln -s . imap
tar jxvf %SOURCE8

%patch1 -p2 -b .ALT
%patch2 -p1 -b .deb-port
%patch5 -p1 -b .overflow
%patch10 -p1 -b .authmd5
%patch13 -p1 -b .poll

%if %WithMaildir
%patch20 -p1 -b .maildir
%patch22 -p1 -b .glibc-time-maildir
%endif
%patch21 -p1

# RH says:
# It looks like this is required by the license (see COPYRIGHT), so here goes....
%__subst 's/^(char \*version = ".+)(";)/${1}alt$2/g' \
  src/i{mapd/imap,popd/ipop{2,3}}d.c

%build
%add_optflags %optflags_shared -Wno-pointer-sign -fno-strict-aliasing
echo -e "y\ny" | \
# SMP incompatible build
make lnp \
    IP=6 \
%if %WithSSL
    SSLTYPE=unix.nopwd \
%else
    SSLTYPE=none \
%endif
%if %WithMaildir
    EXTRADRIVERS=maildir \
%else
    EXTRADRIVERS= \
%endif
    SPECIALS="MAILSPOOL=%_var/mail SSLDIR=%_ssldir SSLINCLUDE=%_includedir SSLLIB=%_libdir SSLCERTS=%_pemdir"

#cd c-client
#gcc -shared -o lib%name.so.%version -Wl,-soname=lib%name.so.%%major \
#        `ar t lib%name.a` -L/usr/X11R6/lib -ldl -lpam -lcrypto

%install
mkdir -p %buildroot%_man8dir
install -p -m644 src/*/*.8 %buildroot%_man8dir

mkdir -p %buildroot%_sbindir
install -p -m755 ipopd/ipop{2,3}d imapd/imapd %buildroot%_sbindir
ln -s imapd %buildroot%_sbindir/rimapd

mkdir -p %buildroot%_libdir
#install -p -m755 c-client/lib%name.so.%version %buildroot%_libdir
#ln -s lib%name.so.%version %buildroot%_libdir/lib%name.so

# docs:
install -p -m0644 %SOURCE9 README.IMAPS
# remove the not-patched file:
rm -f docs/SSLBUILD.ssl
# we don't wnat it in the main pkg:
mv docs/internal.txt .

#devel
mkdir -p %buildroot%_includedir/%name
install -p -m644 ./c-client/*.h %buildroot%_includedir/%name
install -p -m644 ./src/osdep/tops-20/shortsym.h %buildroot%_includedir/%name
install -p -m644 ./c-client/c-client.a %buildroot%_libdir/libc-client.a

install -p -m640 -D %SOURCE1 "%buildroot%_sysconfdir/pam.d/imap"
install -p -m640 -D %SOURCE1 "%buildroot%_sysconfdir/pam.d/pop"

for f in %SOURCE2 %SOURCE3 %SOURCE12 %SOURCE13 %SOURCE4 \
%if %WithSSL
%SOURCE5 %SOURCE6 \
%endif
; do
	d=${f##*/}
	d=${d%%.xinetd}
	install -p -m640 -D "$f" "%buildroot%_sysconfdir/xinetd.d/$d"
done

%if %WithSSL
# Generate ghost *.pem files
mkdir -p %buildroot%_pemdir
touch %buildroot%_pemdir/{imapd,ipop3d}.pem
chmod 600 %buildroot%_pemdir/{imapd,ipop3d}.pem
%endif

%post
%if %WithSSL
# If no cert, migrate stunnel.pem, or generate a new cert
pushd %_pemdir &> /dev/null || :

ANCESTOR=stunnel.pem
for CERT in imapd.pem ipop3d.pem; do
   if [ ! -e "$CERT" ]; then
      if [ -e "$ANCESTOR" ]; then
         echo -n "%name: Installing your $ANCESTOR certificate as $CERT "
         install -p -m0600 "$ANCESTOR" "$CERT" \
          && echo "succeeded." || echo "failed."
      elif [ -e make-dummy-cert ]; then
         echo "%name: Generating new certificate for $CERT."
        sh -s "$CERT" < make-dummy-cert
      else
        echo "%name: Remember to read docs and make $(pwd)/$CERT!" >&2
      fi
   fi
done || :

popd &> /dev/null || :
%endif

/sbin/service xinetd condreload || :

%postun
if [ $1 = 0 ]; then
	/sbin/service xinetd condreload || :
fi

#%files -n lib%name
#%_libdir/*.so.*

%files devel
#%_libdir/*.so
%_libdir/*.*a
%_includedir/*
%doc internal.txt

%files
%config(noreplace) %_sysconfdir/*.d/*
%_sbindir/*
%_man8dir/*
%doc README LICENSE* docs/*
%if %WithSSL
%doc README.IMAPS
%endif

%if %WithSSL
%attr(0600,root,root) %ghost %config(missingok,noreplace) %verify(not md5 size mtime) %_pemdir/*.pem
%endif

%changelog
