%def_with check

Name:    vcmmd
Version: 8.0.5
Release: alt1

Summary: Virtuozzo containers memory management daemon
License: LGPL-2.1
Group:   System/Configuration/Other

URL:     https://src.openvz.org/
Vcs:     https://src.openvz.org/scm/ovz/vcmmd.git

Packager: Andrew A. Vasilyev <andy@altlinux.org>

Source:  %name-%version.tar
Patch: %name-%version.patch

ExclusiveArch: x86_64

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: lib%name
BuildRequires: systemd
BuildRequires: gcc-c++

%if_with check
BuildRequires: /proc
BuildRequires: python3-module-mock python3-module-pytest python3-module-psutil
%endif

%description
Virtuozzo containers memory management daemon

%prep
%setup -n %name-%version
%patch -p1

%build
%python3_build

%install
# Local setup.py fails to parse "--root=path" option, only "--root path" variant:
%__python3 setup.py install --skip-build --root %buildroot --install-scripts %_sbindir

%if_with check
%check
export PYTHONPATH=%buildroot%python3_sitelibdir
pushd tests
%__python3 test_util_misc.py
popd
%endif

%files
%doc COPYING
%_sbindir/*
%python3_sitelibdir/*
%_unitdir/%name.service
%_sysconfdir/vz/vcmmd.d/
%config(noreplace) %_sysconfdir/dbus-1/system.d/com.virtuozzo.vcmmd.conf
%config(noreplace) %_sysconfdir/vz/*.conf
%config(noreplace) %_sysconfdir/logrotate.d/*
%config %_tmpfilesdir/vcmmd-tmpfiles.conf

%changelog
