%define _unpackaged_files_terminate_build 1

Name: verilator
Version: 4.226
Release: alt1
Summary: A fast and free Verilog HDL simulator

Group: Engineering
License: LGPLv3 or Artistic-2.0
Url: https://www.veripool.org/wiki/verilator

# VCS: https://github.com/verilator/verilator
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
ExcludeArch: armh

BuildRequires: flex gcc-c++
BuildRequires: rpm-build-python3
BuildRequires: perl-podlators tex(dehypht.tex)
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: gdb /proc

%description
Verilator is the fastest free Verilog HDL simulator, and beats most commercial
simulators. It compiles synthesizable Verilog, plus some PSL, SystemVerilog and
Synthesis assertions into C++ or SystemC code. It is designed for large projects
where fast simulation performance is of primary concern, and is especially well
suited to generate executable models of CPUs for embedded software design teams.

%package -n %name-doc
Summary: A fast and free Verilog HDL simulator - documentation and examples
Group: Engineering
BuildArch: noarch

%description -n %name-doc
Verilator is the fastest free Verilog HDL simulator, and beats most commercial
simulators. This package contains documentation and examples.

%prep
%setup

%build
autoconf
%configure
%make_build all info

%check
%make test

%install
%makeinstall_std
mkdir -p %buildroot%_pkgconfigdir/
mv %buildroot%_datadir/pkgconfig/%name.pc %buildroot%_pkgconfigdir/%name.pc
mkdir -p %buildroot%_docdir/%name/
mv %buildroot%_datadir/%name/examples %buildroot%_docdir/%name/


%files -n %name
%_bindir/*
%_datadir/%name/
%_man1dir/*
%_pkgconfigdir/%name.pc

%files -n %name-doc
%doc verilator.pdf docs/_build/html
%_docdir/%name/

%changelog
