
%define _libexecdir /usr/libexec

Name: virt-manager
Version: 4.1.0
Release: alt2
Summary: Virtual Machine Manager

Group: Emulators
License: GPLv2+
Url: https://virt-manager.org/
BuildArch: noarch
AutoReqProv: nopython

# https://github.com/virt-manager/virt-manager
Source: %name-%version.tar
Source2: %name-ru.po
Patch0001: 0001-fixed-build-with-python3-module-docutils-on-p9-branch.patch
# Patch: %%name-%%version-%%release.patch

Requires: virt-manager-common = %EVR
Requires: libvirt-client
Requires: virt-install = %EVR
Requires: python3-module-pygobject3 >= 3.31.3
Requires: python3-module-libxml2
Requires: vte3
Requires: dconf
Requires: libosinfo >= 0.2.10
Requires: librsvg
Requires: xorriso

# define version of requires based on "from gi.repository import foo"
Requires: typelib(Gtk) = 3.0
Requires: typelib(GtkVnc) = 2.0
Requires: typelib(GtkSource) = 4
Requires: typelib(SpiceClientGtk) = 3.0
Requires: typelib(Vte) = 2.91

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-setuptools python3-module-argcomplete
BuildRequires: libgio
BuildRequires: gettext-tools
BuildRequires: python3-module-docutils
BuildRequires: bash-completion

%add_python3_lib_path %_datadir/%name
%allow_python3_import_path %_datadir/%name
# libaptindicator is not package in ALT Linux
%add_typelib_req_skiplist typelib(AppIndicator3)
%add_typelib_req_skiplist typelib(AyatanaAppIndicator3)

%description
Virtual Machine Manager provides a graphical tool for administering
virtual machines for KVM, Xen, and QEmu. Start, stop, add or remove
virtual devices, connect to a graphical or serial console, and see
resource usage statistics for existing VMs on local or remote machines.
Uses libvirt as the backend management API.

%package common
Summary: Common files used by the different Virtual Machine Manager interfaces
Group: Emulators
AutoReqProv: nopython

%description common
Common files used by the different virt-manager interfaces, as well as
virt-install related tools.

%package -n virt-install
Summary: Utilities for installing virtual machines
Group: Emulators
AutoReqProv: nopython

Requires: virt-manager-common = %EVR

Provides: virt-clone = %EVR
Provides: virt-xml = %EVR

%description -n virt-install
Package includes several command line utilities, including virt-install
(build and install new VMs) and virt-clone (clone an existing virtual
machine).

%prep
%setup
#%%patch -p1
%patch0001 -p1
cp -f %SOURCE2 po/ru.po

%build
python3 setup.py configure

#%%python_build

%install
#%%python_install
python3 setup.py \
    --no-update-icon-cache --no-compile-schemas \
    install --root=%buildroot

%find_lang --with-gnome %name

# Replace '#!/usr/bin/env python3' with '#!/usr/bin/python3'
# The format is ideal for upstream, but not a distro. See:
# https://fedoraproject.org/wiki/Features/SystemPythonExecutablesUseSystemPython
for f in $(find %buildroot -type f -executable -print); do
    sed -i "1 s|^#!/usr/bin/env python3|#!/usr/bin/python3|" $f || :
done

%files
%_bindir/%name
%_datadir/%name/ui/*.ui
%_datadir/%name/virtManager
%_datadir/%name/icons
%_desktopdir/%name.desktop
%_datadir/metainfo/%name.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.png
%_datadir/glib-2.0/schemas/*.gschema.xml

%_man1dir/%name.1*
%doc README.md COPYING NEWS.md

%files common -f %name.lang
%dir %_datadir/%name
%_datadir/%name/virtinst

%files -n virt-install
%_bindir/virt-install
%_bindir/virt-clone
%_bindir/virt-xml
%_datadir/bash-completion/completions/virt-install
%_datadir/bash-completion/completions/virt-clone
%_datadir/bash-completion/completions/virt-xml
%_man1dir/virt-install.1*
%_man1dir/virt-clone.1*
%_man1dir/virt-xml.1*

%changelog
