%def_disable demos
%define major 1

Name: vkd3d
Version: 1.6
Release: alt1
Summary: The vkd3d 3D Graphics Library

Group: System/Libraries
License: LGPL-2.1
Url: https://source.winehq.org/git/vkd3d.git/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libvulkan-devel spirv-headers wine-devel-tools
BuildRequires: libspirv-tools-devel spirv-tools flex
%if_enabled demos
BuildRequires: libxcb-devel libxcbutil-devel libxcbutil-keysyms-devel libxcbutil-icccm-devel
%endif

# same as wine
ExclusiveArch: %ix86 x86_64 aarch64

# fix LTO
%global optflags_lto %optflags_lto -ffat-lto-objects

%description
Vkd3d is a 3D graphics library built on top of Vulkan. It has an API very
similar, but not identical, to Direct3D 12.

%package -n lib%{name}%{major}
Summary: %{name} libraries
Group: System/Libraries

%description -n lib%{name}%{major}
Vkd3d is a 3D graphics library built on top of Vulkan. It has an API very
similar, but not identical, to Direct3D 12.

%package devel
Summary: %name development package
Group: Development/C
Requires: lib%{name}%{major} = %EVR
Requires: %name-utils = %EVR

%description devel
Development headers for %name.

%package utils
Summary: %name utils
Group: Development/C
Requires: lib%{name}%{major} = %EVR

%description utils
%name utils.

%package demos
Summary: %name demos
Group: Development/C
Requires: lib%{name}%{major} = %EVR

%description demos
%name demos.

%prep
%setup
%patch -p1
%autoreconf
%configure \
  %{subst_enable demos} \
  --with-spirv-tools

%build
%make_build

%install
%makeinstall
%if_enabled demos
mkdir -p %buildroot%_bindir
for f in demos/{gears,triangle}; do
  cp -a "$i" %buildroot%_bindir/%{name}_"$f";
done
%endif

%files -n lib%{name}%{major}
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files utils
%_bindir/vkd3d-compiler

%if_enabled demos
%files demos
%_bindir/*
%exclude %_bindir/vkd3d-compiler
%endif

%changelog
