Name: volk
Version: 2.4.1
Release: alt1
Summary: Vector-Optimized Library of Kernels
License: GPLv3
Group: Development/C++
Url: http://libvolk.org/

Source: %name-%version.tar
Source1: cpu_features.tar

%description
VOLK:
- is the Vector-Optimized Library of Kernels;
- is a free library, currently offered under the GPLv3 license;
- provides an abstraction of optimized math routines targetting several SIMD processors.

%package -n lib%name
Group: Development/C++
Summary: Vector-Optimized Library of Kernels
BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: liborc-devel orc
BuildRequires: boost-filesystem-devel
BuildRequires: git-core

%description -n lib%name
VOLK:
- is the Vector-Optimized Library of Kernels;
- is a free library, currently offered under the GPLv3 license;
- provides an abstraction of optimized math routines targetting several SIMD processors.

%package -n lib%name-devel
Summary: Vector-Optimized Library of Kernels
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
VOLK:
- is the Vector-Optimized Library of Kernels;
- is a free library, currently offered under the GPLv3 license;
- provides an abstraction of optimized math routines targetting several SIMD processors.

%package -n python3-module-%name
Summary: The Python 3 bindings for VOLK
Group: Development/Python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-six
BuildRequires: python3-module-mako
Requires: lib%name = %version

%description -n python3-module-%name
Python 3 module for VOLK.

%prep
%setup -a 1

%build
%cmake \
	-DGR_PYTHON_DIR=%python3_sitelibdir \
	-DPYTHON_EXECUTABLE=%__python3

%cmake_build

%install
%cmakeinstall_std

# Not needed
rm -f %buildroot%_bindir/list_cpu_features
rm -f %buildroot%_libdir/libcpu_features.a
rm -fr %buildroot%_libdir/cmake/CpuFeatures

%files
%_bindir/*
%doc COPYING README.md

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_libdir/cmake/%name

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
