%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

%if_enabled qtwebengine
%add_python3_req_skip PyQt5.QtWebKit PyQt5.QtWebKitWidgets
%else
%add_python3_req_skip PyQt5.QtWebEngineCore PyQt5.QtWebEngineWidgets
%endif

Name:    weboob
Version: 2.0
Release: alt5

Summary: Weboob is a collection of applications able to interact with websites, without requiring the user to open them in a browser
License: AGPL-3.0+
Group:   Networking/WWW
URL:     http://weboob.org/

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires: rpm-build-python3
BuildRequires: python3-module-distribute
BuildRequires: python3-module-PyQt5-devel

Source: %name-%version.tar
Patch1: weboob-alt-disable-webkit-formatter.patch
Patch2: weboob-alt-import-from-urllib3-directly.patch

Requires: python3-module-weboob = %EVR

%description
Weboob is a collection of applications able to interact with websites,
without requiring the user to open them in a browser.

%package -n python3-module-weboob
Summary: Python module for Weboob
Group: Development/Python3
%description -n python3-module-weboob
Python module for Weboob.

%prep
%setup -n %name-%version
%patch1 -p1
%patch2 -p1
# Remove unsupported formatter
rm -rf weboob/tools/application/formatters/webkit
# Set correct python3 executable in shebang
subst 's|#!.*python[0-9.]*$|#!%__python3|' $(grep -Rl '#!.*python[0-9.]*$' *)
%if_disabled qtwebengine
rm -rf weboob/tools/blinkpdf.py
%endif

%build
%python3_build

%install
%python3_install
if [ "%python3_sitelibdir" != "%python3_sitelibdir_noarch" ] ; then
    mkdir -p %buildroot/%python3_sitelibdir
    mv %buildroot/%python3_sitelibdir_noarch/* %buildroot/%python3_sitelibdir/
fi
mkdir -p %buildroot%_desktopdir
cp -a desktop/*.desktop %buildroot%_desktopdir
mkdir -p %buildroot%_iconsdir/hicolor/64x64/apps
cp -a icons/*.png %buildroot%_iconsdir/hicolor/64x64/apps

%files
%_bindir/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.*
%_man1dir/*

%files -n python3-module-weboob
%python3_sitelibdir/%name/
%python3_sitelibdir/*.egg-info

%changelog
