%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: wget
Version: 1.24.5
Release: alt4

Summary: A free utility for non-interactive download of files from the Web
License: GPL-3.0-or-later
Group: Networking/WWW
Url: http://www.gnu.org/software/wget/wget.html
Vcs: https://git.savannah.gnu.org/cgit/wget.git

Source: %name-%version.tar

BuildRequires: autoconf-archive
BuildRequires: flex
BuildRequires: gnulib
BuildRequires: gperf
BuildRequires: libcap-devel
BuildRequires: libcares-devel
BuildRequires: libidn2-devel
BuildRequires: libseccomp-devel
BuildRequires: libssl-devel
BuildRequires: libunistring-devel
BuildRequires: makeinfo
BuildRequires: perl-Pod-Usage
BuildRequires: texinfo
BuildRequires: zlib-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: perl-HTTP-Daemon
BuildRequires: perl-IO-Socket-SSL
BuildRequires: strace
}}

%description
GNU Wget is a free utility for non-interactive download of files from
the Web. It supports HTTP, HTTPS, and FTP protocols. Wget features
include the ability to work in the background while you're logged out,
recursive retrieval of directories, file name wildcard matching, remote
file timestamp storage and comparison, use of Rest with FTP servers
and Range with HTTP servers to retrieve files over slow or unstable
connections, support for Proxy servers, and configurability.

%prep
%setup

# Fix docs and samples.
rm -f doc/*.info*
find doc -type f -print0 |
	xargs -r0 grep -FZl /usr/local/ -- |
	xargs -r0 sed -i 's,/usr/local/,/,g' --

%build
if [ ! -e .tarball-version ]; then
	# Update from Git.
	echo "%version-%release"> .tarball-version
	./bootstrap \
		--gnulib-srcdir=/usr/share/gnulib \
		--no-bootstrap-sync \
		--no-git \
		--skip-po
fi
%ifarch %e2k
# lcc-1.23.12: work around the lack of some builtins
%add_optflags -D__ICC -D__STRICT_ANSI__
%endif
%configure \
	--disable-nls \
	--disable-ntlm \
	--with-cares \
	--with-ssl=openssl
%make_build V=1

%install
%makeinstall

%find_lang --output=%name.lang %name %name-gnulib

%check
src/wget --version
export SECCOMP_DEFAULT_ACTION=trap
if ! strace -o a -f -e t=none -e s=sys -- %make_build -C tests check VERBOSE=1; then
	grep syscall= a
	exit 1
else
	! grep syscall= a
fi

%files -f %name.lang
%doc COPYING ChangeLog* AUTHORS MAILING-LIST NEWS README*
%config(noreplace) %_sysconfdir/wgetrc
%_bindir/wget
%_man1dir/wget.1*
%_infodir/wget.info*

%changelog
