%define _unpackaged_files_terminate_build 1

Name: wireguard-tools

Version: 1.0.20210914
Release: alt2

Summary: Tools for WireGuard: fast, modern, secure VPN tunnel
Summary(ru_RU.UTF-8): Утилиты для WireGuard, быстрого, современного, защищенного VPN-туннеля
License: GPLv2
Group: System/Servers
Url: https://www.wireguard.com/
#Git: https://git.zx2c4.com/wireguard-tools/

Source0: %name-%version.tar
Patch1: wireguard-tools-1.0.20200513-completion-exit-early-with-bash-less-than-4.patch

Obsoletes: bash-completion-wireguard < %EVR
Conflicts: bash-completion-wireguard < %EVR
Conflicts: wg-quick < %EVR

%package wg-quick
Summary: Tools' extension for WireGuard: fast, modern, secure VPN tunnel
Summary(ru_RU.UTF-8): Дополнительные утилиты для WireGuard, быстрого, современного, защищенного VPN-туннеля
License: GPLv2
Group: Networking/Remote access
Requires: %name = %EVR
Provides: wg-quick = %EVR
Obsoletes: wg-quick < %EVR
Conflicts: bash-completion-wireguard < %EVR
BuildArch: noarch

%filter_from_requires /^sudo$/d

%package examples
Summary: Example scripts for WireGuard: fast, modern, secure VPN tunnel
Summary(ru_RU.UTF-8): Скрипты-примеры для WireGuard, быстрого, современного, защищенного VPN-туннеля
License: GPLv2
Group: Networking/Remote access
BuildArch: noarch

%description
Utilities package for WireGuard.
WireGuard is an extremely simple yet fast and modern VPN that utilizes
state-of-the-art cryptography. It aims to be faster, simpler, leaner, and more
useful than IPSec, while avoiding the massive headache. It intends to be
considerably more performant than OpenVPN. WireGuard is designed as a general
purpose VPN for running on embedded interfaces and super computers alike, fit
for many different circumstances. Initially released for the Linux kernel, it
plans to be cross-platform and widely deployable. It is currently under heavy
development, but already it might be regarded as the most secure, easiest to
use, and simplest VPN solution in the industry.

%description wg-quick
Utilities extension package for WireGuard.
WireGuard is an extremely simple yet fast and modern VPN that utilizes
state-of-the-art cryptography.

%description examples
Example scripts package for WireGuard.
WireGuard is an extremely simple yet fast and modern VPN that utilizes
state-of-the-art cryptography.

%prep
%setup
%patch1 -p1
sed -i 's|%_bindir|%_sbindir|g' src/systemd/wg-quick@.service

%build
pushd src
%make_build
popd

%install
pushd src
%makeinstall \
	WITH_WGQUICK="yes" \
	WITH_BASHCOMPLETION="yes" \
	WITH_SYSTEMDUNITS="yes" \
	SYSTEMDUNITDIR=%_unitdir \
	DESTDIR=%buildroot \
	BINDIR=%_sbindir \
	MANDIR=%_mandir \
	RUNSTATEDIR=/run
popd

%files
%doc README.md COPYING
%_man8dir/wg.8*
%_sbindir/wg
%_datadir/bash-completion/completions/wg

%files wg-quick
%_man8dir/wg-quick.8*
%_sbindir/wg-quick
%_unitdir/wg-quick@.service
%_unitdir/wg-quick.target
%_datadir/bash-completion/completions/wg-quick
%dir %_sysconfdir/wireguard

%files examples
%doc contrib/*

%changelog
