# vim: set ft=spec: -*- rpm-spec -*-

%def_with nghttp2

# Wireshark has huge number of plugins that are not linked against most of the external libraries
# as they are loaded into wireshark/tshark processes which guarantee that linkage
%set_verify_elf_method unresolved=relaxed

%define _pluginsdir %_libdir/%name/plugins/4.4

Name: wireshark
Version: 4.4.5
Release: alt1

Summary: The BugTraq Award Winning Network Traffic Analyzer
Group: Monitoring
License: GPLv2
Url: https://www.wireshark.org/
VCS: https://gitlab.com/wireshark/wireshark.git
Source: http://www.wireshark.org/download/src/%name-%version.tar
Source2: %name.control
Source3: %name.watch
Patch0: %name-%version-%release.patch

BuildRequires: control doxygen flex gcc-c++ libadns-devel libcap-devel libcom_err-devel libgnutls-openssl-devel libgcrypt-devel zlib-devel
BuildRequires: libkrb5-devel libpcap-devel libportaudio2-devel libssl-devel python3 unzip xml-utils xsltproc perl-Pod-Parser perl-devel
BuildRequires: liblua5.1-compat-devel
BuildRequires: libssh-devel
BuildRequires: libnl-devel
%if_with nghttp2
BuildRequires: libnghttp2-devel
%endif
BuildRequires: liblz4-devel
BuildRequires: libxml2-devel
BuildRequires: libspandsp3-devel
BuildRequires: libsnappy-devel
BuildRequires: libcares-devel
BuildRequires: libsmi-devel
BuildRequires: libGeoIP-devel
BuildRequires: libglib2-devel
BuildRequires: qt6-base-devel qt6-multimedia-devel qt6-tools-devel qt6-svg-devel qt6-5compat-devel
BuildRequires: cmake
BuildRequires: libsystemd-devel
BuildRequires: libmaxminddb-devel
BuildRequires: asciidoctor
BuildRequires: libbcg729-devel >= 1.0.4-alt1
BuildRequires: libsbc-devel
BuildRequires: libnettle-devel
BuildRequires: libminizip-devel
BuildRequires: libzstd-devel
BuildRequires: libspeexdsp-devel
BuildRequires: libbrotli-devel
BuildRequires: libpcre2-devel
BuildRequires: libcares-devel
BuildRequires: git
BuildRequires(pre):rpm-build-xdg

%package base
Summary: Wireshark base package
Group: Monitoring
Obsoletes: ethereal-libs < 0.10.10
Obsoletes: libwiretap
Obsoletes: ethereal-base

%package qt
Summary: QT GUI for Wireshark package
Group: Monitoring
Requires: %name-base = %EVR
Provides: %name = %EVR
Provides: %name-qt5 = %EVR
Obsoletes: %name-qt5 < %EVR
Requires: url_handler
Obsoletes: ethereal

%package -n tshark
Summary: Console GUI for Wireshark package
Group: Monitoring
Requires: %name-base = %EVR
Obsoletes: tethereal

%package devel
Summary: Development environment for wireshark extensions 
Group: Development/C
Requires: wireshark-base = %EVR
Obsoletes: libwiretap-devel < %EVR

%description
Wireshark (formerly Ethereal) is a network protocol analyzer, or
"packet sniffer", that lets you capture and interactively browse
the contents of network frames. The goal of the project is to
create a commercial-quality packet analyzer for Unix, and the
most useful packet analyzer on any platform.

%description base
Wireshark (formerly Ethereal) is a network protocol analyzer, or
"packet sniffer", that lets you capture and interactively browse
the contents of network frames. The goal of the project is to
create a commercial-quality packet analyzer for Unix, and the
most useful packet analyzer on any platform.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, plugins and documentation
for wireshark. A graphical user interface is packaged separately to
GTK+/QT5 packages.

%description qt
This package contains QT GUI ie. the wireshark -- application.

%description -n tshark
This package contains console wireshark application.

%description devel
This package contains development files needed to develop wireshark
extensions.

%prep
%setup
%patch0 -p1

%build
# Some plugins use C++ and need lcxa. It can't be loaded
# dynamically, so all binaries should be linked with it.
%ifarch %e2k
cc --version | grep -q '^lcc:1.21' && export LIBS+=" -lcxa"
%endif
%cmake -DBUILD_sharkd=off
%cmake_build

%install
%cmakeinstall_std
%cmake_install --component Development
rm -f %buildroot%_libdir/%name/plugins/%version/*.la

mkdir -p %buildroot{%_controldir,%_menudir,%_datadir/applications,%_niconsdir,%_liconsdir,%_miconsdir,%_iconsdir/hicolor/scalable/apps}
cp -p resources/icons/wsicon16.png %buildroot%_miconsdir/wireshark.png
cp -p resources/icons/wsicon32.png %buildroot%_niconsdir/wireshark.png
cp -p resources/icons/wsicon48.png %buildroot%_liconsdir/wireshark.png
cp -p resources/wslogo.svg %buildroot%_iconsdir/hicolor/scalable/apps/wireshark.svg

mkdir -p %buildroot%_includedir/wiretap
install -p -m644 wiretap/wtap.h %buildroot%_includedir/wiretap/wtap.h

install -p -m755 %_sourcedir/%name.control %buildroot%_controldir/%name-capture

# Rename qt binary:
mv -v %buildroot%_bindir/%name %buildroot%_bindir/%name-qt

# Make alternatives:
mkdir -p %buildroot%_altdir
cat <<'_EOF'_ > %buildroot%_altdir/%name-qt
%_bindir/%name	%_bindir/%name-qt	20
_EOF_

%pre base
%pre_control %name-capture

%post base
%post_control -s relaxed %name-capture

%files base
%doc AUTHORS COPYING ChangeLog INSTALL README* doc/README.*
%config %_controldir/%name-capture
%_bindir/capinfos
%_bindir/captype
%attr(700,root,root) %verify(not mode,group) %_bindir/dumpcap
%_bindir/editcap
%_bindir/mergecap
%_bindir/randpkt
%_bindir/rawshark
%_bindir/text2pcap
%_bindir/reordercap
%_bindir/mmdbresolve
%_man1dir/androiddump.*
%_man1dir/capinfos.*
%_man1dir/captype.*
%_man1dir/ciscodump.*
%_man1dir/dpauxmon.*
%_man1dir/etwdump.*
%_man1dir/udpdump.*
%_man1dir/sshdump.*
%_man1dir/mmdbresolve.*
%_man1dir/randpkt.*
%_man1dir/randpktdump.*
%_man1dir/sdjournal.*
%_man1dir/dumpcap.*
%_man1dir/editcap.*
%_man1dir/mergecap.*
%_man1dir/rawshark.*
%_man1dir/text2pcap.*
%_man1dir/reordercap.*
%_man1dir/wifidump.*
%_man4dir/wireshark-filter.*
%_man4dir/extcap.*
%_datadir/%name
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%dir %_pluginsdir
%dir %_libdir/%name/extcap
%_libdir/%name/extcap/*
%_pluginsdir/*
%_libdir/lib%name.so.*
%_libdir/libwsutil.so.*
%_libdir/libwiretap.so.*
%_man1dir/wireshark.*
%_man1dir/falcodump.*
%_iconsdir/hicolor/*/mimetypes/*.png
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_xdgmimedir/packages/org.wireshark.Wireshark.xml
%_datadir/metainfo/org.wireshark.Wireshark.metainfo.xml

%files qt
%_altdir/%name-qt
%_bindir/wireshark-qt
%_datadir/applications/org.wireshark.Wireshark.desktop

%files -n tshark
%_bindir/tshark
%_man1dir/tshark.*

%files devel
%_bindir/idl2wrs
%_includedir/wiretap
%_libdir/libwiretap.so
%_includedir/wireshark
%_libdir/libwireshark.so
%_libdir/libwsutil.so
%_pkgconfigdir/wireshark.pc
%_libdir/cmake/%name

%changelog
