Name: xfce4-clipman-plugin
Version: 1.6.7
Release: alt1

Summary: Clipboard history plugin for the Xfce panel
Summary(ru_RU.UTF-8): Менеджер буфера обмена для Xfce
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/%name
Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-clipman-plugin.git
Packager: Xfce Team <xfce@packages.altlinux.org>

Source: %name-%version.tar
Patch: %name-%version-%release.patch

%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif

BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools
BuildRequires: libxfce4panel-gtk3-devel libxfce4ui-gtk3-devel libxfconf-devel libxfce4util-devel
BuildRequires: xorg-proto-devel libXtst-devel
BuildRequires: libqrencode-devel
%{?_enable_wayland:BuildRequires: wayland-devel libwayland-client-devel wlr-protocols}
BuildRequires: rpm-build-xdg

Requires: xfce4-panel

%define _unpackaged_files_terminate_build 1

%description
Clipman is a clipboard manager for Xfce. It keeps the clipboard contents
around while it is usually lost when you close an application.
It is able to handle text and images, and has a feature to execute
actions on specific text selections by matching them against regular
expressions.

%description -l ru_RU.UTF-8
Clipman это менеджер буфера обмена для Xfce. Он сохраняет содержимое
буфера обмена, которое обычно теряется при закрытии приложения. Он
способен обрабатывать как текст так и изображения, а также имеет
функцию, позволяющую выполнять конкретные действия по выбору текста
путем сопоставления их с регулярными выражениями.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--disable-static \
	--enable-libqrencode \
	--enable-x11 \
	%{subst_enable wayland} \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%doc README.md NEWS AUTHORS
%_bindir/*
%_libdir/xfce4/panel/plugins/*.so
%_datadir/xfce4/panel/plugins/*.desktop
%_iconsdir/hicolor/*/apps/*
%_miconsdir/*
%_niconsdir/*
%_desktopdir/*
%_xdgconfigdir/xfce4/panel/*
%_xdgconfigdir/autostart/*
%_datadir/metainfo/*

%exclude %_libdir/xfce4/panel/plugins/*.la

%changelog
