Name: xfce4-power-manager
Version: 4.18.4
Release: alt1
Summary: Power management for the Xfce desktop environment
Summary (ru_RU.UTF8): Утилита расширенного управления питанием для Xfce

Group: Graphical desktop/XFce
License: GPLv2+
Url: https://docs.xfce.org/xfce/xfce4-power-manager/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/xfce4-power-manager.git
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util libxfconf-devel libxfce4panel-gtk3-devel
BuildRequires: libxfce4ui-gtk3-devel >= 4.18.4
BuildRequires: libXext-devel
BuildRequires: libXrandr-devel
BuildRequires: libnotify-devel >= 0.4.1
BuildRequires: libupower-devel
BuildRequires: gettext

Requires: polkit
Requires: upower

Conflicts: xfce4-screensaver < 0.1.10-alt1

%define _unpackaged_files_terminate_build 1

%description
This software is a power manager for the Xfce desktop, Xfce power
manager manages the power sources on the computer and the devices that
can be controlled to reduce their power consumption (such as LCD
brightness level, monitor sleep). In addition, xfce4-power-manager
provides a set of freedesktop-compliant DBus interfaces to inform other
applications about current power level so that they can adjust their
power consumption, and it provides the inhibit interface which allows
applications to prevent automatic sleep actions via the power manager.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-polkit \
	--enable-network-manager \
	--with-backend=linux \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README.md
%config %_sysconfdir/xdg/autostart/%name.desktop
%_bindir/*
%_sbindir/xfpm-power-backlight-helper
%_sbindir/xfce4-pm-helper
%_libdir/xfce4/panel/plugins/*.so
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*.*
%_datadir/xfce4/panel/plugins/*.desktop
%_datadir/polkit-1/actions/*.policy
%_mandir/man?/*
%_datadir/metainfo/*.xml

%exclude %_libdir/xfce4/panel/plugins/*.la

%changelog
